// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#if defined(__cplusplus_cli)
#define HK_VDB_CLI_MANAGED
#elif defined(__cplusplus_winrt)
#define HK_VDB_CLI_NATIVE
#else
// We have two unmanaged files we need to compile in our managed project
#define HK_VDB_CLI_UNMANAGED
#endif

#if defined(HK_VDB_CLI_MANAGED)
#define HK_VDB_MCLI_PP_PUSH_MANAGED( on_or_off ) __pragma( managed( push, on_or_off ) )
#define HK_VDB_MCLI_PP_POP() __pragma( managed( pop ) )
#define HK_VDB_MCLI_PP_SWITCH_MANAGED() __pragma( managed )
#define HK_VDB_MCLI_PP_SWITCH_UNMANAGED() __pragma( unmanaged )
#define HK_VDB_MCLI_INCLUDE( _include_ ) <_include_>
#define HK_VDB_IF_MANAGED( ... ) __VA_ARGS__
#define HK_VDB_DECLARE_MDTOR( _type_ ) ~_type_()
#define HK_VDB_DECLARE_PASSTHROUGH_MDTOR( _type_ ) ~_type_() { this->!_type_(); }
#define HK_VDB_DECLARE_UMDTOR( _type_ ) !_type_()
#define HK_VDB_DEFINE_MDTOR( _type_ ) _type_::~_type_()
#define HK_VDB_DEFINE_UMDTOR( _type_ ) _type_::!_type_()
#pragma warning( disable : 4793 )
#else
#define HK_VDB_MCLI_PP_PUSH_MANAGED( on_or_off )
#define HK_VDB_MCLI_PP_POP()
#define HK_VDB_MCLI_PP_SWITCH_MANAGED()
#define HK_VDB_MCLI_PP_SWITCH_UNMANAGED()
#define HK_VDB_MCLI_INCLUDE( _include_ ) <Common/Base/hkBase.h>
#define HK_VDB_IF_MANAGED( ... )
#endif

#if defined(HK_VDB_CLI_NATIVE)
#define HK_VDB_NCLI_INCLUDE( _include_ ) <_include_>
#define HK_VDB_IF_NATIVE( ... ) __VA_ARGS__
#define HK_VDB_DECLARE_MDTOR( _type_ )
#define HK_VDB_DECLARE_PASSTHROUGH_MDTOR( _type_ )
#define HK_VDB_DECLARE_UMDTOR( _type_ ) virtual ~_type_()
#define HK_VDB_DEFINE_MDTOR( _type_ )
#define HK_VDB_DEFINE_UMDTOR( _type_ ) _type_::~_type_()
#else
#define HK_VDB_NCLI_INCLUDE( _include_ ) <Common/Base/hkBase.h>
#define HK_VDB_IF_NATIVE( ... )
#endif

#if defined(HK_VDB_CLI_UNMANAGED)
#define HK_VDB_UMCLI_INCLUDE( _include_ ) <_include_>
#define HK_VDB_IF_UNMANAGED( ... ) __VA_ARGS__
#else
#define HK_VDB_UMCLI_INCLUDE( _include_ ) <Common/Base/hkBase.h>
#define HK_VDB_IF_UNMANAGED( ... )
#endif

HK_VDB_MCLI_PP_PUSH_MANAGED( on )

#include HK_VDB_MCLI_INCLUDE( windows.h )
#include HK_VDB_MCLI_INCLUDE( vcclr.h )
#include HK_VDB_NCLI_INCLUDE( wrl.h )
#include HK_VDB_NCLI_INCLUDE( collection.h )
#include HK_VDB_UMCLI_INCLUDE( windows.h )


#if defined(HK_VDB_CLI_MANAGED)
#define clinew gcnew
namespace CLI = System;
#define RenderSurfaceCLI System::Windows::Controls::Panel
#define StreamCLI System::IO::Stream
#define ListCLI System::Collections::Generic::IList
#define ListCLIImpl System::Collections::Generic::List
#define ListCLIAddMethod Add
#define MapCLI System::Collections::Generic::IDictionary
#define MapCLIImpl System::Collections::Generic::Dictionary
#define ReadOnlyListCLI System::Collections::Generic::IReadOnlyList
#define PropertyBagCLI System::Collections::Generic::IReadOnlyCollection<Property^>
#define PropertyBagCLIImpl System::Collections::ObjectModel::ReadOnlyCollection<Property^>
#define PropertyChangedEventArgsCLI System::ComponentModel::PropertyChangedEventArgs
#define ArrayCLI array
#define ColorCLI System::Windows::Media::Color
#define PointCLI System::Windows::Point
#define KeyCLI CLI::Windows::Input::Key
#define ArgumentExceptionCLI System::ArgumentException
#define InvalidOperationExceptionCLI System::InvalidOperationException
#define MetadataCLI System
#define IpAddressCLI System::Net::IPAddress
template <typename T> struct WeakCLIPtr
{
    WeakCLIPtr() : m_ptr( gcnew System::WeakReference( nullptr ) ) {}
    WeakCLIPtr( T ptr ) : m_ptr( gcnew System::WeakReference( ptr ) ) {}
    WeakCLIPtr( const WeakCLIPtr& other ) : m_ptr( gcnew System::WeakReference( other.m_ptr ) ) {}
    WeakCLIPtr& operator=( T t ) { setPtr( t ); return *this; }
    WeakCLIPtr& operator=( const WeakCLIPtr& other ) { setPtr( other.m_ptr ); return *this; }
    operator T () const { return getPtr(); }
    T operator->() const { return getPtr(); }
    operator bool() const { return getPtr() != nullptr; }
private:
    void setPtr( T ptr ) { m_ptr->Target = ptr; }
    T getPtr() const { return dynamic_cast< T >( m_ptr->Target ); }
    gcroot<System::WeakReference^> m_ptr;
};
template<typename T> struct StrongCLIPtr : public gcroot<T>
{
    StrongCLIPtr() : gcroot<T>() {}
    StrongCLIPtr( T ptr ) : gcroot<T>( ptr ) {}
    StrongCLIPtr( const StrongCLIPtr& other ) : gcroot<T>( other ) {}
    StrongCLIPtr& operator=( T t ) { gcroot<T>::operator =( t ); return *this; }
    StrongCLIPtr& operator=( const StrongCLIPtr& other ) { gcroot<T>::operator =( other ); return *this; }
    operator bool() const { return gcroot<T>::operator T() != nullptr; }
};
#endif

#if defined(HK_VDB_CLI_NATIVE)
#define clinew ref new
namespace CLI = Platform;
#define RenderSurfaceCLI Windows::UI::Xaml::Controls::SwapChainPanel
#define StreamCLI Windows::Storage::Streams::IInputStream
#define ListCLI Windows::Foundation::Collections::IVector
#define ListCLIImpl Platform::Collections::Vector
#define ListCLIAddMethod Append
#define ReadOnlyListCLI Windows::Foundation::Collections::IVectorView
#define PropertyBagCLI Windows::Foundation::Collections::IPropertySet
#define PropertyBagCLIImpl Windows::Foundation::Collections::PropertySet
#define PropertyChangedEventArgsCLI Windows::UI::Xaml::Data::PropertyChangedEventArgs
#define ArrayCLI Platform::Array
#define ColorCLI Windows::UI::Color
#define PointCLI Windows::Foundation::Point
#define KeyCLI Windows::System::VirtualKey
#define ArgumentExceptionCLI Platform::InvalidArgumentException
#define InvalidOperationExceptionCLI Platform::FailureException
#define MetadataCLI Platform::Metadata

#define IpAddressCLI Windows::Networking::Connectivity::IPInformation

template <typename T> struct WeakCLIPtr
{
    WeakCLIPtr() {}
    WeakCLIPtr( T ptr ) : m_ptr( ptr ) {}
    WeakCLIPtr( const WeakCLIPtr& other ) : m_ptr( other.m_ptr ) {}
    WeakCLIPtr& operator=( T t ) { m_ptr = t; return *this; }
    WeakCLIPtr& operator=( const WeakCLIPtr& other ) { m_ptr = other.m_ptr; return *this; }
    operator T () const { return m_ptr; }
    T operator->() const { return m_ptr; }
    operator bool() const { return getPtr(); }
private:
    T m_ptr;
};
template<typename T>
using StrongCLIPtr = WeakCLIPtr<T>;
#endif


#if 0
namespace Havok
{
    namespace Vdb
    {
        public ref class VdbException sealed : CLI::Runtime::InteropServices::_Exception
        {
        public:
            VdbException(E)

            virtual System::String^ ToString() override;

            virtual Boolean Equals( System::Object^ obj ) override;

            virtual Int32 GetHashCode() override;

            virtual System::Type^ GetType() override;

            virtual System::Exception GetBaseException() override;

            virtual Void GetObjectData( System::Runtime::Serialization::SerializationInfo^ info, System::Runtime::Serialization::StreamingContext^ context ) override;
        };
    }
}
#endif

#define VDB_VERIFY_OPERATION( OPERATION, ERROR_REPORTER ) \
    HK_MULTILINE_MACRO_BEGIN \
        if ( ( OPERATION ).isFailure() ) \
        { \
            HK_ASSERT( 0x22441087, ( ERROR_REPORTER ).getError(), "Reporter should have an error" ); \
            ( ERROR_REPORTER ).reportError(); \
            ( ERROR_REPORTER ).clearError(); \
        } \
    HK_MULTILINE_MACRO_END

HK_VDB_MCLI_PP_SWITCH_UNMANAGED()

#include <Common/Base/hkBase.h>
#include <Common/Base/Container/String/hkUtf8.h>

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
