// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/Color/hkColor.h>
#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>
#include <Graphics/Common/Input/Keyboard/hkgKeyboardDefines.h>
#include <VisualDebugger/VdbServices/System/hkVdbTypes.h>

#if !defined(HK_VDB_CLI_UNMANAGED)
namespace Havok
{
    namespace Vdb
    {
        public value struct Vector sealed
        {
#if defined(HK_VDB_CLI_MANAGED)
            Vector( float x ) : X( x ), Y( 0 ), Z( 0 ), W( 0 ) {}
            Vector( float x, float y ) : X( x ), Y( y ), Z( 0 ), W( 0 ) {}
            Vector( float x, float y, float z ) : X( x ), Y( y ), Z( z ), W( 0 ) {}
            Vector( float x, float y, float z, float w ) : X( x ), Y( y ), Z( z ), W( w ) {}
            Vector( double x, double y, double z, double w ) : X( float( x ) ), Y( float( y ) ), Z( float( z ) ), W( float( w ) ) {}
#endif
            float X;
            float Y;
            float Z;
            float W;
            virtual CLI::String^ ToString() override { return L"{ X=" + X + L", Y=" + Y + L", Z=" + Z + L", W=" + W + L" }"; }
        };

        public value struct Aabb sealed
        {
#if defined(HK_VDB_CLI_MANAGED)
            Aabb( Vector& min, Vector& max ) : Min( min ), Max( max ) {}
#endif
            Vector Min;
            Vector Max;
            virtual CLI::String^ ToString() override { return L"{ Min=" + Min + L", Max=" + Max + L" }"; }
        };

        public value struct Rotation sealed
        {
#if defined(HK_VDB_CLI_MANAGED)
            Rotation( Vector col0, Vector col1, Vector col2 ) : Col0( col0 ), Col1( col1 ), Col2( col2 ) {}
#endif
            Vector Col0;
            Vector Col1;
            Vector Col2;
            virtual CLI::String^ ToString() override { return L"{ Col0=" + Col0 + L", Col1=" + Col1 + L", Col2=" + Col2 + L" }"; }
        };

        public value struct Transform sealed
        {
#if defined(HK_VDB_CLI_MANAGED)
            Transform( Vector translation, Havok::Vdb::Rotation rotation ) : Translation( translation ), Rotation( rotation ) {}
#endif
            Vector Translation;
            Havok::Vdb::Rotation Rotation;
            virtual CLI::String^ ToString() override { return L"{ Translation=" + Translation + L", Rotation=" + Rotation + L" }"; }
        };

        public interface struct IReadOnlyProperty
        {
            property CLI::String^ Name { CLI::String^ get(); }
            property Object^ Value { Object^ get(); }
        };

        public ref class ReadOnlyProperty : public IReadOnlyProperty
        {
        public:
            ReadOnlyProperty( System::String^ name, Object^ value ) : _Name( name ) { _Value = value; }
            property System::String^ Name { virtual System::String^ get() { return _Name; } }
            property Object^ Value { virtual Object^ get() { return _Value; } }
        protected:
            System::String^ _Name;
            Object^ _Value;
        };

#if defined(HK_VDB_CLI_MANAGED)
        public interface struct IProperty : public System::ComponentModel::INotifyPropertyChanged
        {
            property CLI::String^ Name { CLI::String^ get(); }
            property Object^ Value { Object^ get(); void set( Object^ ); }
        };

        public ref class Property : public IProperty
        {
        public:
            virtual event System::ComponentModel::PropertyChangedEventHandler ^ PropertyChanged;
            Property( System::String^ name, Object^ value ) : _Name( name ) { _Value = value; }
            property System::String^ Name { virtual System::String^ get() { return _Name; } }
            property Object^ Value
            {
                virtual Object^ get()
                {
                    return _Value;
                }
                virtual void set( Object^ value )
                {
                    if ( ( ( _Value == nullptr ) != ( value == nullptr ) ) ||
                        ( ( _Value != nullptr ) && !_Value->Equals( value ) ) )
                    {
                        _Value = value;
                        PropertyChanged( this, clinew System::ComponentModel::PropertyChangedEventArgs( _Name ) );
                    }
                }
            }
        protected:
            System::String^ _Name;
            Object^ _Value;
        };

        
        typedef System::Collections::Generic::IReadOnlyDictionary<CLI::String^, IProperty^> IPropertySet;
        typedef System::Collections::Generic::IReadOnlyDictionary<CLI::String^, IReadOnlyProperty^> IReadOnlyPropertySet;
#else
#error Need to move above constructs into the cli.h as #defines and fix the CameraController stuff in RenderSurface to use for managed, then can do UWP version properly
#endif

        public interface struct Object
        {
            property CLI::IntPtr Ptr { CLI::IntPtr get(); }
            property CLI::IntPtr Type { CLI::IntPtr get(); }
            property CLI::String^ TypeName { CLI::String^ get(); }
            property IReadOnlyPropertySet^ Properties { IReadOnlyPropertySet^ get(); }
            property IReadOnlyPropertySet^ RawProperties { IReadOnlyPropertySet^ get(); }
        };
    }
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
