// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

namespace Havok
{
    namespace Reflect
    {
        
        
        
        
        

        template<typename HKTYPE>
        HK_INLINE static bool Equals( const hkReflect::Type* type )
        {
#if 0
            
            return object.getType()->equals( object );;
#else
            const hkReflect::Type* hktype = hkReflect::getType<HKTYPE>();
            HK_ASSERT( 0x22441375, hktype, "Not a valid type for inheritance check" );
            return ( hkReflect::TypeName::compare( type->getFullName(), hktype->getFullName() ) == 0 );
#endif
        }

        // Our native types for typedefs report their resolved name while their serialized
        // counterparts do not. This has the potential to really byte us down the road I think.
        // See COM-4253.
        template<>
        HK_INLINE static bool Equals<hkVector4>( const hkReflect::Type* type )
        {
            return ( hkString::strCmp( HK_PP_STRINGIFY_NAME( hkVector4 ), type->getName() ) == 0 );
        }
        template<>
        HK_INLINE static bool Equals<hkRotation>( const hkReflect::Type* type )
        {
            return ( hkString::strCmp( HK_PP_STRINGIFY_NAME( hkRotation ), type->getName() ) == 0 );
        }
        template<>
        HK_INLINE static bool Equals<hkTransform>( const hkReflect::Type* type )
        {
            return ( hkString::strCmp( HK_PP_STRINGIFY_NAME( hkTransform ), type->getName() ) == 0 );
        }

        template<typename HKTYPE>
        static bool ExtendsOrEquals( const hkReflect::Type* type )
        {
#if 0
            
            return type->extendsOrEquals( type );
#else
            const hkReflect::Type* targetType = hkReflect::getType<HKTYPE>();
            HK_ASSERT( 0x22441353, targetType, "Not a valid type for inheritance check" );
            if ( targetType )
            {
                for ( const hkReflect::Type* currentType = type; currentType; currentType = currentType->getParent() )
                {
                    if ( ( targetType == currentType ) || ( hkReflect::TypeName::compare( targetType->getFullName(), currentType->getFullName() ) == 0 ) )
                    {
                        return true;
                    }
                }
            }
            return false;
#endif
        }

        template<typename HKTYPE>
        static bool Implements( const hkReflect::Type* type )
        {
#if 0
            
            return type->implements( type );
#else
            const hkReflect::Type* targetType = hkReflect::getType<HKTYPE>();
            HK_ASSERT( 0x22441374, targetType, "Not a valid type for inheritance check" );
            if ( targetType )
            {
                for ( const hkReflect::Type* currentType = type; currentType; currentType = currentType->getParent() )
                {
                    if ( ( targetType == currentType ) || ( hkReflect::TypeName::compare( targetType->getFullName(), currentType->getFullName() ) == 0 ) )
                    {
                        return true;
                    }
                }
            }
            return false;
#endif
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
