// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbServicesCLI/Types.h>

namespace Havok
{
    namespace Vdb
    {
        namespace Convert
        {
            namespace String
            {
                template<typename ToTypeCLI = CLI::String^>
                static ToTypeCLI ToCLI( const char* hkstr ) { return hkUtf8::WideFromUtf8( hkstr ); }
                template<typename FromTypeCLI = CLI::String^>
                static const char* FromCLI( FromTypeCLI clistr, hkStringBuf& hkstorage ) { hkstorage = hkUtf8::Utf8FromWide( clistr ); return hkstorage; }
            }

            namespace Vector
            {
                HK_VDB_IF_MANAGED( static Havok::Vdb::Vector ToCLI( hkVector4Parameter hkvec ) { return Havok::Vdb::Vector( hkvec( 0 ), hkvec( 1 ), hkvec( 2 ), hkvec( 3 ) ); } )
                HK_VDB_IF_NATIVE( static Havok::Vdb::Vector ToCLI( hkVector4Parameter hkvec ) { return { hkvec( 0 ), hkvec( 1 ), hkvec( 2 ), hkvec( 3 ) }; } )
                HK_VDB_IF_MANAGED( static Havok::Vdb::Vector ToCLI( float* hkvec ) { return Havok::Vdb::Vector( hkvec[0], hkvec[1], hkvec[2], 0 ); } )
                HK_VDB_IF_NATIVE( static Havok::Vdb::Vector ToCLI( float* hkvec ) { return { hkvec[0], hkvec[1], hkvec[2], 0 }; } )
                static hkVector4* FromCLI( Havok::Vdb::Vector clivec, hkVector4* hkstorage ) { static_cast<float&>((*hkstorage)(0)) = clivec.X; static_cast<float&>((*hkstorage)(1)) = clivec.Y; static_cast<float&>((*hkstorage)(2)) = clivec.Z; return hkstorage; }
                static float* FromCLI( Havok::Vdb::Vector clivec, float* hkstorage ) { hkstorage[0] = clivec.X; hkstorage[1] = clivec.Y; hkstorage[2] = clivec.Z; return hkstorage; }
            }

            namespace Aabb
            {
                HK_VDB_IF_MANAGED( static Havok::Vdb::Aabb ToCLI( const hkAabb& hkaabb ) { return Havok::Vdb::Aabb( Vector::ToCLI( hkaabb.m_min ), Vector::ToCLI( hkaabb.m_max ) ); } )
                HK_VDB_IF_NATIVE( static Havok::Vdb::Aabb ToCLI( const hkAabb& hkaabb ) { return { Vector::ToCLI( hkaabb.m_min ), Vector::ToCLI( hkaabb.m_max ) }; } )
                HK_VDB_IF_MANAGED( static Havok::Vdb::Aabb ToCLI( float* hkmin, float* hkmax ) { return Havok::Vdb::Aabb( Vector::ToCLI( hkmin ), Vector::ToCLI( hkmax ) ); } )
                HK_VDB_IF_NATIVE( static Havok::Vdb::Aabb ToCLI( float* hkmin, float* hkmax ) { return { Vector::ToCLI( hkmin ), Vector::ToCLI( hkmax ) }; } )
                static hkAabb* FromCLI( Havok::Vdb::Aabb cliaabb, hkAabb* hkstorage ) { Vector::FromCLI( cliaabb.Min, &hkstorage->m_min ); Vector::FromCLI( cliaabb.Max, &hkstorage->m_max ); return hkstorage; }
                static void FromCLI( Havok::Vdb::Aabb cliaabb, float* hkminstorage, float* hkmaxstorage ) { Vector::FromCLI( cliaabb.Min, hkminstorage ); Vector::FromCLI( cliaabb.Max, hkmaxstorage ); }
            }

            namespace Rotation
            {
                HK_VDB_IF_MANAGED( static Havok::Vdb::Rotation ToCLI( const hkRotation& hkrot ) { return Havok::Vdb::Rotation( Vector::ToCLI( hkrot.m_col0 ), Vector::ToCLI( hkrot.m_col1 ), Vector::ToCLI( hkrot.m_col2 ) ); } )
                HK_VDB_IF_NATIVE( static Havok::Vdb::Rotation ToCLI( const hkRotation& hkrot ) { return { Vector::ToCLI( hkrot.m_col0 ), Vector::ToCLI( hkrot.m_col1 ), Vector::ToCLI( hkrot.m_col2 ) }; } )
            }

            namespace Transform
            {
                HK_VDB_IF_MANAGED( static Havok::Vdb::Transform ToCLI( const hkTransform& hktransform ) { return Havok::Vdb::Transform( Vector::ToCLI( hktransform.getTranslation() ), Rotation::ToCLI( hktransform.getRotation() ) ); } )
                HK_VDB_IF_NATIVE( static Havok::Vdb::Transform ToCLI( const hkTransform& hktransform ) { return { Vector::ToCLI( hktransform.getTranslation() ), Rotation::ToCLI( hktransform.getRotation() ) }; } )
            }

            namespace Color
            {
                template<typename FromType, typename ToTypeCLI>
                static ToTypeCLI ToCLI( FromType hkcolor );
                template<typename FromTypeCLI>
                static hkColor::Argb FromCLI( FromTypeCLI clicolor );
            }

            namespace Enum
            {
                template<typename FromType, typename ToTypeCLI>
                static ToTypeCLI ToCLI( FromType hkenum );
                template<typename FromTypeCLI, typename ToType>
                static ToType FromCLI( FromTypeCLI clienum );
            }

            namespace Flags
            {
                template<typename FromType, typename ToTypeCLI, hkInt32 Mask = 0xffffffff>
                static ToTypeCLI ToCLI( FromType hkflags );
                template<typename FromTypeCLI, typename ToType>
                static typename ToType::StorageType FromCLI( FromTypeCLI cliflags );
            }

            namespace IpAddress
            {
                template<typename FromType, typename ToTypeCLI = IpAddressCLI^>
                static ToTypeCLI ToCLI( const FromType& ipaddress ) { return template ToCLI<FromType, IpAddressCLI^>( ipAddress ); }
            }

            namespace Stream
            {
                namespace Reader
                {
                    static StreamCLI^ ToCLI( void* data, int size );
                    
                }

                namespace Writer
                {
                    
                    extern class hkStreamWriter* FromCLI( StreamCLI^ stream );
                }
            }

            namespace Array
            {
                template<typename FromType, typename ToTypeCLI, typename ConvertFunc>
                static ListCLI<ToTypeCLI>^ ToCLI( const hkArrayView<FromType>& hkarray, ConvertFunc func );

                template<typename FromType, typename ToTypeCLI>
                static ListCLI<ToTypeCLI>^ ToCLI( const hkArrayView<FromType>& hkarray )
                {
                    auto convert = []( int idx, FromType& hkobject )
                    {
                        return hkobject;
                    };
                    return ToCLI<FromType, ToTypeCLI>( hkarray, convert );
                }

                template<typename TypeCLI>
                static ReadOnlyListCLI<TypeCLI>^ ToCLIReadOnly( ListCLI<TypeCLI>^ clilist );

                template<typename FromTypeCLI, typename ToType, typename ConvertFunc>
                static void FromCLI( ListCLI<FromTypeCLI>^ cliarray, hkArray<ToType>& hkarray, ConvertFunc func );

                template<typename FromTypeCLI, typename ToType, typename ConvertFunc>
                static void FromCLI( ListCLI<FromTypeCLI>^ cliarray, const hkArray<ToType>& hkarray, ConvertFunc func )
                {
                    FromCLI<FromTypeCLI, ToType>( cliarray, const_cast< hkArray<ToType>& >( hkarray ), func );
                }

                template<typename FromTypeCLI, typename ToType>
                static void FromCLI( ListCLI<FromTypeCLI>^ cliarray, hkArray<ToType>& hkarray )
                {
                    auto convert = []( int idx, FromTypeCLI cliobject )
                    {
                        return cliobject;
                    };
                    FromCLI<FromTypeCLI, ToType>( cliarray, const_cast< hkArray<ToType>& >( hkarray ), convert );
                }

                template<typename FromTypeCLI, typename ToType>
                static void FromCLI( ListCLI<FromTypeCLI>^ cliarray, const hkArray<ToType>& hkarray )
                {
                    FromCLI<FromTypeCLI, ToType>( cliarray, const_cast< hkArray<ToType>& >( hkarray ) );
                }
            }

            namespace Map
            {
                template<typename FromKeyType, typename FromValueType, typename ToKeyTypeCLI, typename ToValueTypeCLI, typename ConvertFunc>
                static MapCLI<ToKeyTypeCLI, ToValueTypeCLI>^ ToCLI( hkVdbMap<FromKeyType, FromValueType>& hkmap, ConvertFunc func );

                template<typename FromKeyType, typename FromValueType, typename ToKeyTypeCLI, typename ToValueTypeCLI, typename ConvertFunc>
                static MapCLI<ToKeyTypeCLI, ToValueTypeCLI>^ ToCLI( const hkVdbMap<FromKeyType, FromValueType>& hkmap, ConvertFunc func )
                {
                    return ToCLI<FromKeyType, FromValueType, ToKeyTypeCLI, ToValueTypeCLI>( const_cast< hkVdbMap<FromKeyType, FromValueType>& >( hkmap ), func );
                }

                template<typename FromKeyType, typename FromValueType, typename ToKeyTypeCLI, typename ToValueTypeCLI>
                static MapCLI<ToKeyTypeCLI, ToValueTypeCLI>^ ToCLI( hkVdbMap<FromKeyType, FromValueType>& hkmap )
                {
                    auto convert = []( FromType& hkobject )
                    {
                        return hkobject;
                    };
                    return ToCLI<FromKeyType, FromValueType, ToKeyTypeCLI, ToValueTypeCLI>( const_cast< hkVdbMap<FromKeyType, FromValueType>& >( hkmap ), convert );
                }

                template<typename FromKeyType, typename FromValueType, typename ToKeyTypeCLI, typename ToValueTypeCLI>
                static MapCLI<ToKeyTypeCLI, ToValueTypeCLI>^ ToCLI( const hkVdbMap<FromKeyType, FromValueType>& hkmap )
                {
                    return ToCLI<FromKeyType, FromValueType, ToKeyTypeCLI, ToValueTypeCLI>( const_cast< hkVdbMap<FromKeyType, FromValueType>& >( hkmap ) );
                }
            }

            namespace Key
            {
                template<typename FromTypeCLI, typename ToType>
                static ToType FromCLI( FromTypeCLI clikey );
            }

            namespace Object
            {
                extern CLI::Object^ ToCLI( const hkReflect::Var& hkobject, bool raw );
            }
        }
    }
}

namespace Havok
{
    namespace Vdb
    {
        namespace Convert
        {
            namespace Color
            {
                template<typename FromType, typename ToTypeCLI>
                static ToTypeCLI ToCLI( FromType hkcolor )
                {
                    ToTypeCLI clicolor;
                    clicolor.A = hkColor::getAlphaAsChar( hkcolor );
                    clicolor.R = hkColor::getRedAsChar( hkcolor );
                    clicolor.G = hkColor::getGreenAsChar( hkcolor );
                    clicolor.B = hkColor::getBlueAsChar( hkcolor );
                    return clicolor;
                }
                template<typename FromTypeCLI>
                static hkColor::Argb FromCLI( FromTypeCLI clicolor )
                {
                    return hkColor::fromArgb(
                        clicolor.A,
                        clicolor.R,
                        clicolor.G,
                        clicolor.B );
                }
            }

            namespace Enum
            {
                template<typename FromType, typename ToTypeCLI>
                static ToTypeCLI ToCLI( FromType hkenum )
                {
#if defined(HK_VDB_CLI_MANAGED)
                    if ( !CLI::Enum::IsDefined( ToTypeCLI::typeid, clinew CLI::Int32( hkenum ) ) )
                    {
                        
                        throw clinew InvalidOperationExceptionCLI( "Unknown native enum value" );
                    }
#endif
                    return ( ToTypeCLI ) hkenum;
                }
                template<typename FromTypeCLI, typename ToType>
                static ToType FromCLI( FromTypeCLI clienum )
                {
                    return ( ToType ) clienum;
                }
            }

            namespace Flags
            {
                template<typename FromType, typename ToTypeCLI, hkInt32 Mask>
                static ToTypeCLI ToCLI( FromType hkflags )
                {
#if defined(HK_VDB_CLI_MANAGED)
                    FromType hkflagsCheck = hkflags;
                    hkflagsCheck.andWith( FromType::StorageType( Mask ) );
                    CLI::Array^ values = CLI::Enum::GetValues( ToTypeCLI::typeid );
                    for ( int i = 0; i < values->Length; i++ )
                    {
                        const hkUint32 ui32 = CLI::Convert::ToUInt32( values->GetValue( i ) );
                        const FromType::StorageType iS = FromType::StorageType( ui32 );
                        hkflagsCheck.clear( iS );
                    }

                    if ( hkflagsCheck.get() != 0 )
                    {
                        
                        throw clinew InvalidOperationExceptionCLI( "Unknown native flag value" );
                    }
#endif
                    return ( ToTypeCLI ) int( hkflags );
                }

                template<typename FromTypeCLI, typename ToType>
                static typename ToType::StorageType FromCLI( FromTypeCLI cliflags )
                {
                    return ToType::StorageType( cliflags );
                }
            }

            namespace IpAddress
            {
                template<>
                static IpAddressCLI^ ToCLI<hkUint32, IpAddressCLI^>( const hkUint32& ipaddress ) { return clinew IpAddressCLI( 0x00000000ffffffff & ipaddress ); }
                template<>
                static IpAddressCLI^ ToCLI<hkInt32, IpAddressCLI^>( const hkInt32& ipaddress ) { return clinew IpAddressCLI( 0x00000000ffffffff & ipaddress ); }
                template<>
                static IpAddressCLI^ ToCLI<hkUint64, IpAddressCLI^>( const hkUint64& ipaddress ) { return clinew IpAddressCLI( ipaddress ); }
                template<>
                static IpAddressCLI^ ToCLI<hkInt64, IpAddressCLI^>( const hkInt64& ipaddress ) { return clinew IpAddressCLI( ipaddress ); }
            }

            namespace Stream
            {
                namespace Reader
                {
                    static StreamCLI^ ToCLI( void* data, int size )
                    {
#if defined(HK_VDB_CLI_MANAGED)
                        return clinew System::IO::UnmanagedMemoryStream(
                            reinterpret_cast< hkUint8* >( data ),
                            size,
                            size,
                            System::IO::FileAccess::Read );
#else
                        
                        HK_ASSERT_NOT_IMPLEMENTED( 0x0 );
                        return nullptr;
#endif
                    }
                }
            }

            namespace Array
            {
                template<typename FromType, typename ToTypeCLI, typename ConvertFunc>
                static ListCLI<ToTypeCLI>^ ToCLI( const hkArrayView<FromType>& hkarray, ConvertFunc convert )
                {
                    ListCLI<ToTypeCLI>^ list;
#if defined(HK_VDB_CLI_MANAGED)
                    list = clinew System::Collections::Generic::List<ToTypeCLI>( hkarray.getSize() );
                    for ( int i = 0; i < hkarray.getSize(); i++ )
                    {
                        list->Add( convert( i, hkarray[i] ) );
                    }
#else
                    list = clinew Platform::Collections::Vector<ToTypeCLI>( hkarray.getSize() );
                    for ( int i = 0; i < hkarray.getSize(); i++ )
                    {
                        list->Append( convert( i, hkarray[i] ) );
                    }
#endif
                    return list;
                }

                template<>
                ListCLI<CLI::String^>^ ToCLI( const hkArrayView<const char*>& hkarray )
                {
                    auto convert = []( int idx, const char*& hkstr )
                    {
                        return hkUtf8::WideFromUtf8( hkstr ).operator System::String ^();
                    };
                    return ToCLI<const char*, CLI::String^>( hkarray, convert );
                }

                template<typename TypeCLI>
                static ReadOnlyListCLI<TypeCLI>^ ToCLIReadOnly( ListCLI<TypeCLI>^ clilist )
                {
#if defined(HK_VDB_CLI_MANAGED)
                    return dynamic_cast< System::Collections::Generic::List<TypeCLI>^ >( clilist )->AsReadOnly();
#else
                    return dynamic_cast< Platform::Collections::Vector<TypeCLI>^ >( clilist )->GetView();
#endif
                }

                template<typename FromTypeCLI, typename ToType, typename ConvertFunc>
                static void FromCLI( ListCLI<FromTypeCLI>^ cliarray, hkArray<ToType>& hkarray, ConvertFunc convert )
                {
                    hkarray.setSize( ( cliarray != nullptr ) ? cliarray->Count : 0 );
                    for ( int i = 0; i < hkarray.getSize(); i++ )
                    {
                        hkarray[i] = convert( i, cliarray[i] );
                    }
                }

                template<>
                void FromCLI( ListCLI<CLI::String^>^ cliarray, hkArray<hkStringPtr>& hkarray )
                {
                    auto convert = []( int idx, CLI::String^ clistr )
                    {
                        return hkUtf8::Utf8FromWide( clistr ).cString();
                    };
                    FromCLI<CLI::String^, hkStringPtr>( cliarray, hkarray, convert );
                }
            }

            namespace Map
            {
                template<typename FromKeyType, typename FromValueType, typename ToKeyTypeCLI, typename ToValueTypeCLI, typename ConvertFunc>
                static MapCLI<ToKeyTypeCLI, ToValueTypeCLI>^ ToCLI( hkVdbMap<FromKeyType, FromValueType>& hkmap, ConvertFunc convert )
                {
                    MapCLI<ToKeyTypeCLI, ToValueTypeCLI>^ map;
#if defined(HK_VDB_CLI_MANAGED)
                    map = clinew System::Collections::Generic::Dictionary<ToKeyTypeCLI, ToValueTypeCLI>( hkmap.getSize() );
                    for ( hkVdbMap<FromKeyType, FromValueType>::Iterator iter = hkmap.getIterator();
                        hkmap.isValid( iter );
                        iter = hkmap.getNext( iter ) )
                    {
                        
                        
                        FromKeyType& key = const_cast<FromKeyType&>( hkmap.getKey( iter ) );
                        FromValueType& val = const_cast<FromValueType&>( hkmap.getValue( iter ) );
                        System::Tuple<ToKeyTypeCLI, ToValueTypeCLI>^ tup = convert( key, val );
                        map->Add( tup->Item1, tup->Item2 );
                    }
#else
#error todo
#endif
                    return map;
                }
            }

            namespace Key
            {
#if defined(HK_VDB_CLI_MANAGED)
                template<>
                static HKG_KEYBOARD_VKEY FromCLI<KeyCLI, HKG_KEYBOARD_VKEY>( KeyCLI clikey )
                {
                    using Key = CLI::Windows::Input::Key;

                    
                    
                    switch ( clikey )
                    {
                        case Key::Back: return HKG_VKEY_BACK;
                        case Key::Tab: return HKG_VKEY_TAB;

                        case Key::Return: return HKG_VKEY_RETURN;
                        case Key::LeftShift: return ( /*HKG_VKEY_LSHIFT | */HKG_VKEY_SHIFT );
                        case Key::RightShift: return ( /*HKG_VKEY_RSHIFT | */HKG_VKEY_SHIFT );
                        case Key::LeftCtrl: return ( /*HKG_VKEY_LCONTROL | */HKG_VKEY_CONTROL );
                        case Key::RightCtrl: return ( /*HKG_VKEY_RCONTROL | */HKG_VKEY_CONTROL );
                        case Key::LeftAlt: return ( /*HKG_VKEY_LMENU | */HKG_VKEY_MENU );
                        case Key::RightAlt: return ( /*HKG_VKEY_RMENU | */HKG_VKEY_MENU );

                        case Key::Capital: return HKG_VKEY_CAPITAL;

                        case Key::Escape: return HKG_VKEY_ESCAPE;
                        case Key::Space: return HKG_VKEY_SPACE;
                        case Key::End: return HKG_VKEY_END;
                        case Key::Home: return HKG_VKEY_HOME;

                        case Key::Left: return HKG_VKEY_LEFT;
                        case Key::Up: return HKG_VKEY_UP;
                        case Key::Right: return HKG_VKEY_RIGHT;
                        case Key::Down: return HKG_VKEY_DOWN;

                        case Key::Insert: return HKG_VKEY_INSERT;
                        case Key::Delete: return HKG_VKEY_DELETE;

                        /* HKG_VKEY_0 thru HKG_VKEY_9 are the same as ASCII '0' thru '9' (0x30 - 0x39) */
                        case Key::D0: return '0';
                        case Key::D1: return '1';
                        case Key::D2: return '2';
                        case Key::D3: return '3';
                        case Key::D4: return '4';
                        case Key::D5: return '5';
                        case Key::D6: return '6';
                        case Key::D7: return '7';
                        case Key::D8: return '8';
                        case Key::D9: return '9';

                        /* HKG_VKEY_A thru HKG_VKEY_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A) */
                        case Key::A: return 'A';
                        case Key::B: return 'B';
                        case Key::C: return 'C';
                        case Key::D: return 'D';
                        case Key::E: return 'E';
                        case Key::F: return 'F';
                        case Key::G: return 'G';
                        case Key::H: return 'H';
                        case Key::I: return 'I';
                        case Key::J: return 'J';
                        case Key::K: return 'K';
                        case Key::L: return 'L';
                        case Key::M: return 'M';
                        case Key::N: return 'N';
                        case Key::O: return 'O';
                        case Key::P: return 'P';
                        case Key::Q: return 'Q';
                        case Key::R: return 'R';
                        case Key::S: return 'S';
                        case Key::T: return 'T';
                        case Key::U: return 'U';
                        case Key::V: return 'V';
                        case Key::W: return 'W';
                        case Key::X: return 'X';
                        case Key::Y: return 'Y';
                        case Key::Z: return 'Z';

                        case Key::LWin: return HKG_VKEY_LWIN;
                        case Key::RWin: return HKG_VKEY_RWIN;
                        case Key::Apps: return HKG_VKEY_APPS;
                        case Key::NumPad0: return HKG_VKEY_NUMPAD0;
                        case Key::NumPad1: return HKG_VKEY_NUMPAD1;
                        case Key::NumPad2: return HKG_VKEY_NUMPAD2;
                        case Key::NumPad3: return HKG_VKEY_NUMPAD3;
                        case Key::NumPad4: return HKG_VKEY_NUMPAD4;
                        case Key::NumPad5: return HKG_VKEY_NUMPAD5;
                        case Key::NumPad6: return HKG_VKEY_NUMPAD6;
                        case Key::NumPad7: return HKG_VKEY_NUMPAD7;
                        case Key::NumPad8: return HKG_VKEY_NUMPAD8;
                        case Key::NumPad9: return HKG_VKEY_NUMPAD9;

                        case Key::Multiply: return HKG_VKEY_MULTIPLY;
                        case Key::Add: return HKG_VKEY_ADD;
                        case Key::Separator: return HKG_VKEY_SEPARATOR;
                        case Key::Subtract: return HKG_VKEY_SUBTRACT;
                        case Key::Decimal: return HKG_VKEY_DECIMAL;
                        case Key::Divide: return HKG_VKEY_DIVIDE;

                        case Key::F1: return HKG_VKEY_F1;
                        case Key::F2: return HKG_VKEY_F2;
                        case Key::F3: return HKG_VKEY_F3;
                        case Key::F4: return HKG_VKEY_F4;
                        case Key::F5: return HKG_VKEY_F5;
                        case Key::F6: return HKG_VKEY_F6;
                        case Key::F7: return HKG_VKEY_F7;
                        case Key::F8: return HKG_VKEY_F8;
                        case Key::F9: return HKG_VKEY_F9;
                        case Key::F10: return HKG_VKEY_F10;
                        case Key::F11: return HKG_VKEY_F11;
                        case Key::F12: return HKG_VKEY_F12;
                        case Key::F13: return HKG_VKEY_F13;
                        case Key::F14: return HKG_VKEY_F14;
                        case Key::F15: return HKG_VKEY_F15;
                        case Key::F16: return HKG_VKEY_F16;
                        case Key::F17: return HKG_VKEY_F17;
                        case Key::F18: return HKG_VKEY_F18;
                        case Key::F19: return HKG_VKEY_F19;
                        case Key::F20: return HKG_VKEY_F20;
                        case Key::F21: return HKG_VKEY_F21;
                        case Key::F22: return HKG_VKEY_F22;
                        case Key::F23: return HKG_VKEY_F23;
                        case Key::F24: return HKG_VKEY_F24;

                        case Key::NumLock: return HKG_VKEY_NUMLOCK;
                        case Key::Scroll: return HKG_VKEY_SCROLL;
                        //case Key::Delete: return HKG_VKEY_LMENU;
                        //case Key::Delete: return HKG_VKEY_RMENU;

                        //case Key::Delete: return HKG_VKEY_OEM_1_SEMICOLON;
                        //case Key::Delete: return HKG_VKEY_OEM_PLUS;
                        //case Key::Delete: return HKG_VKEY_OEM_COMMA;
                        //case Key::Delete: return HKG_VKEY_OEM_MINUS;
                        //case Key::Delete: return HKG_VKEY_OEM_PERIOD;
                        //case Key::Delete: return HKG_VKEY_OEM_2_FORWARDSLASH;
                        //case Key::Delete: return HKG_VKEY_OEM_3_TILDA;
                        //case Key::Delete: return HKG_VKEY_OEM_4_OPENBRACKET;
                        //case Key::Delete: return HKG_VKEY_OEM_5_BACKSLASH;
                        //case Key::Delete: return HKG_VKEY_OEM_6_CLOSE_BRACKET;

                        default: return 0;
                    }
                }
#else
                template<>
                HKG_KEYBOARD_VKEY FromCLI<KeyCLI, HKG_KEYBOARD_VKEY>( KeyCLI clikey )
                {
                    
                    HK_ASSERT_NOT_IMPLEMENTED( 0x0 );
                    return 0;
                }
#endif
            }
        }
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
