// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>

#ifdef HK_VDB_CLI_MANAGED
#define RESOLVE_ALL_ENUMERATOR_RESULTS_ON_ACCESS
#endif

HK_VDB_MCLI_PP_PUSH_MANAGED( off )

#include HK_VDB_MCLI_INCLUDE( VisualDebugger/VdbServicesCLI/System/BaseSystem.h )
#include <VisualDebugger/VdbServicesCLI/System/Utils/Reflect.h>

#include <Common/Base/Types/Geometry/Aabb/hkAabbHalf.h>
#include <Common/Base/Types/Geometry/Aabb16/hkAabb16.h>
#include <Common/Base/Types/Geometry/Aabb24_16_24/hkAabb24_16_24.h>
#include <Common/Base/Types/Geometry/IntSpaceUtil/hkIntSpaceUtil.h>
#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/hkServerObjectHandler.h>

HK_VDB_MCLI_PP_SWITCH_MANAGED()

using namespace Havok::Vdb;
using namespace System::Collections::Generic;

namespace Havok
{
    namespace Vdb
    {
        namespace Convert
        {
            namespace Stream
            {
                namespace Writer
                {
                    class NativeStreamWriter : public hkStreamWriter
                    {
                    public:

                        NativeStreamWriter( StreamCLI^ stream ) :
                            m_isOk( true )
                        {
                            HK_VDB_IF_MANAGED( m_stream = stream; )
                        }

                        ~NativeStreamWriter()
                        {
                            // Ensure that we free the streams underlying resources
                            flush();
                            HK_VDB_IF_MANAGED( m_stream->~Stream(); )
                            m_stream = nullptr;
                        }

                        virtual hkBool isOk() const HK_OVERRIDE
                        {
                            return m_isOk HK_VDB_IF_MANAGED( && m_stream->CanWrite );
                        }

                        
                        virtual int write( const void* buf, int nbytes ) HK_OVERRIDE
                        {
                            try
                            {
                                
                                ArrayCLI<hkUint8>^ buffer = clinew ArrayCLI<hkUint8>( nbytes );
                                for ( int i = 0; i < nbytes; i++ )
                                {
                                    buffer[i] = *( reinterpret_cast< hkUint8* >( const_cast< void* >( buf ) ) + i );
                                }
                                
                            }
                            catch ( CLI::Exception^ )
                            {
                                m_isOk = false;
                            }
                            return nbytes;
                        }

                        
                        virtual void flush() HK_OVERRIDE
                        {
                            try
                            {
                                
                            }
                            catch ( CLI::Exception^ )
                            {
                                m_isOk = false;
                            }
                        }

                        
                        //virtual hkBool seekTellSupported() const;
                        //virtual hkResult seek( int offset, SeekWhence whence );
                        //virtual int tell() const;
                        //virtual hkBool isBuffered() const;

                    protected:

                        hkBool m_isOk;
                        StrongCLIPtr<StreamCLI^> m_stream;
                    };

                    extern class hkStreamWriter* FromCLI( StreamCLI^ stream )
                    {
#if defined(HK_VDB_CLI_MANAGED)
                        return new NativeStreamWriter( stream );
#else
                        
                        HK_ASSERT_NOT_IMPLEMENTED( 0x0 );
                        return nullptr;
#endif
                    }
                }
            }

            namespace Object
            {
                ref class NativeReadOnlyPropertySet : public IReadOnlyPropertySet
                {
                public:

                    NativeReadOnlyPropertySet( hkReflect::RecordVar& hkobject, bool raw )
                    {
                        // This is the dangerous bit mentioned in .h event handler code comments...
                        // Basically, if the wrapped object pointer gets deallocated due to eviction from the circ buffer, we have a dangling pointer.
                        // But, if everyone's behaving correctly (and removing said object on remove signal) all will be well.
                        
                        m_hkobject = new hkVdbReflect::Var( hkobject );
                        m_raw = raw;
                    }
                    HK_VDB_DECLARE_PASSTHROUGH_MDTOR( NativeReadOnlyPropertySet );
                    HK_VDB_DECLARE_UMDTOR( NativeReadOnlyPropertySet )
                    {
                        HK_VDB_IF_MANAGED( BaseSystem::getInstance()->initGCThread(); )
                        delete m_hkobject;
                        HK_ON_DEBUG( m_hkobject = HK_NULL; )
                    }

#pragma region IEnumerable

                    ref struct NativePropertyEnumerator : IEnumerator<KeyValuePair<CLI::String^, IReadOnlyProperty^>>
                    {
                        NativePropertyEnumerator( hkVdbReflect::Var* hkobject, bool raw ) :
                            m_hkobject( hkobject ),
                            m_raw( raw ),
                            m_iterator( HK_NULL )
                        {
                            Reset();
                        }
                        HK_VDB_DECLARE_PASSTHROUGH_MDTOR( NativePropertyEnumerator );
                        HK_VDB_DECLARE_UMDTOR( NativePropertyEnumerator )
                        {
                            HK_VDB_IF_MANAGED( BaseSystem::getInstance()->initGCThread(); )
                            delete m_iterator;
                            HK_ON_DEBUG( m_iterator = HK_NULL; )
                        }

                        virtual bool MoveNext()
                        {
                            if ( !m_iterator )
                            {
                                m_iterator = new hkVdbReflect::Var::iterator();
                                ( *m_iterator ) = m_hkobject->begin();
                            }
                            else
                            {
                                ++( *m_iterator );
                            }
                            return ( *m_iterator ) < m_hkobject->end();
                        }

                        property KeyValuePair<CLI::String^, IReadOnlyProperty^> Current
                        {
                            virtual KeyValuePair<CLI::String^, IReadOnlyProperty^> get()
                            {
                                return GetCurrentKeyValuePair();
                            }
                        };

                        property Object^ CurrentNonGeneric
                        {
                            virtual Object^ get() sealed = System::Collections::IEnumerator::Current::get
                            {
                                return GetCurrentKeyValuePair();
                            }
                        };

                        virtual void Reset()
                        {
                            delete m_iterator;
                            m_iterator = HK_NULL;
                        }

                    private:

                        KeyValuePair<CLI::String^, IReadOnlyProperty^> GetCurrentKeyValuePair()
                        {
                            if ( hkReflect::Var prop = **m_iterator )
                            {
                                return CreateKeyValuePairFromNative( m_iterator->name(), prop, m_raw );
                            }
                            else
                            {
                                return KeyValuePair<CLI::String^, IReadOnlyProperty^>();
                            }
                        }

                        hkVdbReflect::Var* m_hkobject;
                        bool m_raw;
                        hkVdbReflect::Var::iterator* m_iterator;
                    };

                    virtual IEnumerator<KeyValuePair<CLI::String^, IReadOnlyProperty^>>^ GetEnumerator()
                    {
#ifdef RESOLVE_ALL_ENUMERATOR_RESULTS_ON_ACCESS
                        return CreateCache()->GetEnumerator();
#else
                        return clinew NativePropertyEnumerator( m_hkobject, m_raw );
#endif
                    }

                    virtual System::Collections::IEnumerator^ GetEnumeratorNonGeneric() sealed = System::Collections::IEnumerable::GetEnumerator
                    {
#ifdef RESOLVE_ALL_ENUMERATOR_RESULTS_ON_ACCESS
                        return CreateCache()->GetEnumerator();
#else
                        return clinew NativePropertyEnumerator( m_hkobject, m_raw );
#endif
                    }

                public:

#pragma endregion

#pragma region IReadOnlyCollection.Enumerables

                    
                    ref struct NativePropertyKeyEnumerable : IEnumerable<System::String ^>
                    {
                        NativePropertyKeyEnumerable( hkVdbReflect::Var* hkobject ) :
                            m_hkobject( hkobject )
                        {}

                        ref struct NativePropertyKeyEnumerator : IEnumerator<System::String ^>
                        {
                            NativePropertyKeyEnumerator( hkVdbReflect::Var* hkobject ) :
                                m_enumerator( clinew NativePropertyEnumerator( hkobject, false /*doesn't matter since we are only grabbing KEYS*/ ) )
                            {}
                            ~NativePropertyKeyEnumerator() {}

                            virtual bool MoveNext()
                            {
                                return m_enumerator->MoveNext();
                            }

                            property System::String ^ Current
                            {
                                virtual System::String ^ get()
                                {
                                    KeyValuePair<CLI::String^, IReadOnlyProperty^> pair = m_enumerator->Current;
                                    return pair.Key;
                                }
                            };

                            property Object^ CurrentNonGeneric
                            {
                                virtual Object^ get() sealed = System::Collections::IEnumerator::Current::get
                                {
                                    KeyValuePair<CLI::String^, IReadOnlyProperty^> pair = m_enumerator->Current;
                                    return pair.Key;
                                }
                            };

                            virtual void Reset()
                            {
                                m_enumerator->Reset();
                            }

                            NativePropertyEnumerator^ m_enumerator;
                        };

                        virtual IEnumerator<System::String ^>^ GetEnumerator()
                        {
                            return clinew NativePropertyKeyEnumerator( m_hkobject );
                        }

                        virtual System::Collections::IEnumerator^ GetEnumeratorNonGeneric() sealed = System::Collections::IEnumerable::GetEnumerator
                        {
                            return clinew NativePropertyKeyEnumerator( m_hkobject );
                        }

                        hkVdbReflect::Var* m_hkobject;
                    };

                    
                    ref struct NativePropertyValueEnumerable : IEnumerable<Havok::Vdb::IReadOnlyProperty ^>
                    {
                        NativePropertyValueEnumerable( hkVdbReflect::Var* hkobject, bool raw ) :
                            m_hkobject( hkobject ),
                            m_raw( raw )
                        {}

                        ref struct NativePropertyValueEnumerator : IEnumerator<Havok::Vdb::IReadOnlyProperty ^>
                        {
                            NativePropertyValueEnumerator( hkVdbReflect::Var* hkobject, bool raw ) :
                                m_enumerator( clinew NativePropertyEnumerator( hkobject, raw ) )
                            {}
                            ~NativePropertyValueEnumerator() {}

                            virtual bool MoveNext()
                            {
                                return m_enumerator->MoveNext();
                            }

                            property Havok::Vdb::IReadOnlyProperty ^ Current
                            {
                                virtual Havok::Vdb::IReadOnlyProperty ^ get()
                                {
                                    KeyValuePair<CLI::String^, IReadOnlyProperty^> pair = m_enumerator->Current;
                                    return pair.Value;
                                }
                            };

                            property Object^ CurrentNonGeneric
                            {
                                virtual Object^ get() sealed = System::Collections::IEnumerator::Current::get
                                {
                                    KeyValuePair<CLI::String^, IReadOnlyProperty^> pair = m_enumerator->Current;
                                return pair.Value;
                                }
                            };

                            virtual void Reset()
                            {
                                m_enumerator->Reset();
                            }

                            NativePropertyEnumerator^ m_enumerator;
                        };

                        virtual IEnumerator<Havok::Vdb::IReadOnlyProperty ^>^ GetEnumerator()
                        {
                            return clinew NativePropertyValueEnumerator( m_hkobject, m_raw );
                        }

                        virtual System::Collections::IEnumerator^ GetEnumeratorNonGeneric() sealed = System::Collections::IEnumerable::GetEnumerator
                        {
                            return clinew NativePropertyValueEnumerator( m_hkobject, m_raw );
                        }

                        hkVdbReflect::Var* m_hkobject;
                        bool m_raw;
                    };

                    property System::Collections::Generic::IEnumerable<System::String ^>^ Keys
                    {
                        virtual System::Collections::Generic::IEnumerable<System::String ^>^ get()
                        {
#ifdef RESOLVE_ALL_ENUMERATOR_RESULTS_ON_ACCESS
                            return CreateCache()->Keys;
#else
                            return clinew NativePropertyKeyEnumerable( m_hkobject );
#endif
                        }
                    }

                    property System::Collections::Generic::IEnumerable<Havok::Vdb::IReadOnlyProperty ^>^ Values
                    {
                        virtual System::Collections::Generic::IEnumerable<Havok::Vdb::IReadOnlyProperty ^>^ get()
                        {
#ifdef RESOLVE_ALL_ENUMERATOR_RESULTS_ON_ACCESS
                            return CreateCache()->Values;
#else
                            return clinew NativePropertyValueEnumerable( m_hkobject, m_raw );
#endif
                        }
                    }

#pragma endregion

#pragma region IReadOnlyCollection

                    property int Count
                    {
                        virtual int get()
                        {
                            return m_hkobject->numProperties();
                        }
                    }

                    property Havok::Vdb::IReadOnlyProperty^ default[CLI::String^]
                    {
                        virtual Havok::Vdb::IReadOnlyProperty^ get( CLI::String^ key )
                        {
                            return FindPropertyByName( m_hkobject, key, m_raw );
                        }
                    };

                    virtual bool ContainsKey( System::String ^key )
                    {
                        hkUtf8::Utf8FromWide hkkey( key );
                        return m_hkobject->hasProperty( hkkey );
                    }

                    virtual bool TryGetValue( System::String ^key, Havok::Vdb::IReadOnlyProperty ^%value )
                    {
                        value = FindPropertyByName( m_hkobject, key, m_raw );
                        return ( value != nullptr );
                    }

#pragma endregion

                private:

#pragma region Helper Functions

#ifdef RESOLVE_ALL_ENUMERATOR_RESULTS_ON_ACCESS
                    MapCLIImpl<CLI::String^, IReadOnlyProperty^>^ CreateCache()
                    {
                        NativePropertyEnumerator^ nativeEnumerator = clinew NativePropertyEnumerator( m_hkobject, m_raw );
                        MapCLIImpl<CLI::String^, IReadOnlyProperty^>^ hkobjectPropertiesCache = clinew MapCLIImpl<CLI::String^, IReadOnlyProperty^>();
                        bool currentIsValid = nativeEnumerator->MoveNext();
                        while ( currentIsValid )
                        {
                            KeyValuePair<CLI::String^, IReadOnlyProperty^> current = nativeEnumerator->Current;
                            hkobjectPropertiesCache->Add( current.Key, current.Value );
                            currentIsValid = nativeEnumerator->MoveNext();
                        }
                        return hkobjectPropertiesCache;
                    }
#endif

                    static IReadOnlyProperty^ FindPropertyByName( hkVdbReflect::Var* hkobject, CLI::String^ name, bool raw )
                    {
                        hkUtf8::Utf8FromWide hkname( name );
                        if ( hkReflect::Var prop = hkobject->findProperty( hkname ) )
                        {
                            return CreatePropertyFromNative( hkname, prop, raw );
                        }
                        return nullptr;
                    }

                    static IReadOnlyProperty^ CreateProperty( const char* name, CLI::Object^ obj )
                    {
                        CLI::String^ propName = Convert::String::ToCLI( name );
                        return clinew ReadOnlyProperty( propName, obj );
                    }
                    static IReadOnlyProperty^ CreateProperty( const wchar_t* name, CLI::Object^ obj )
                    {
                        CLI::String^ propName = clinew CLI::String( name );
                        return clinew ReadOnlyProperty( propName, obj );
                    }
                    static IReadOnlyProperty^ CreatePropertyFromNative( const char* name, hkReflect::Var& var, bool raw )
                    {
                        return CreateProperty( name, Convert::Object::ToCLI( var, raw ) );
                    }
                    static KeyValuePair<CLI::String^, IReadOnlyProperty^> CreateKeyValuePair( const char* name, CLI::Object^ obj )
                    {
                        CLI::String^ propName = Convert::String::ToCLI( name );
                        return KeyValuePair<CLI::String^, IReadOnlyProperty^>( propName, clinew ReadOnlyProperty( propName, obj ) );
                    }
                    static KeyValuePair<CLI::String^, IReadOnlyProperty^> CreateKeyValuePair( const wchar_t* name, CLI::Object^ obj )
                    {
                        CLI::String^ propName = clinew CLI::String( name );
                        return KeyValuePair<CLI::String^, IReadOnlyProperty^>( propName, clinew ReadOnlyProperty( propName, obj ) );
                    }
                    static KeyValuePair<CLI::String^, IReadOnlyProperty^> CreateKeyValuePairFromNative( const char* name, hkReflect::Var& var, bool raw )
                    {
                        IReadOnlyProperty^ prop = CreatePropertyFromNative( name, var, raw );
                        return KeyValuePair<CLI::String^, IReadOnlyProperty^>( prop->Name, prop );
                    }

#pragma endregion

                internal:

                    hkVdbReflect::Var* m_hkobject;
                    bool m_raw;
                };

                ref class NativeObject : public Havok::Vdb::Object
                {
                public:
                    NativeObject( hkReflect::RecordVar& hkobject ) :
                        m_nativePropSet( clinew NativeReadOnlyPropertySet( hkobject, false ) ),
                        m_nativeRawPropSet( clinew NativeReadOnlyPropertySet( hkobject, true ) )
                    {}

#pragma region CLI::Object

                    virtual CLI::String^ ToString() override
                    {
                        hkStringBuf reflectStr;
                        m_nativePropSet->m_hkobject->toString( reflectStr );
                        return Convert::String::ToCLI( reflectStr.cString() );
                    }

#pragma endregion

#pragma region Havok::Vdb::Object

                    property CLI::IntPtr Ptr
                    {
                        virtual CLI::IntPtr get()
                        {
                            return CLI::IntPtr( m_nativePropSet->m_hkobject->getAddress() );
                        }
                    }

                    property CLI::IntPtr Type
                    {
                        virtual CLI::IntPtr get()
                        {
                            if ( const hkReflect::Type* type = m_nativePropSet->m_hkobject->getType() )
                            {
                                return CLI::IntPtr( const_cast<hkReflect::Type*>( type ) );
                            }
                            return CLI::IntPtr::Zero;
                        }
                    }

                    property CLI::String^ TypeName
                    {
                        virtual CLI::String^ get()
                        {
                            if ( const hkReflect::Type* type = m_nativePropSet->m_hkobject->getType() )
                            {
                                return Convert::String::ToCLI( type->getName() );
                            }
                            return L"Unknown";
                        }
                    }

                    property IReadOnlyPropertySet^ Properties
                    {
                        virtual IReadOnlyPropertySet^ get()
                        {
                            return m_nativePropSet;
                        }
                    }

                    property IReadOnlyPropertySet^ RawProperties
                    {
                        virtual IReadOnlyPropertySet^ get()
                        {
                            return m_nativeRawPropSet;
                        }
                    }

#pragma endregion

                private:

                    NativeReadOnlyPropertySet^ m_nativePropSet;
                    NativeReadOnlyPropertySet^ m_nativeRawPropSet;
                };

                CLI::Object^ _ToCLI( hkReflect::IntVar intVar )
                {
                    hkReflect::IntValue intValue = intVar.getValue();
                    switch ( intVar.getType()->getSizeOf() )
                    {
                        case sizeof( hkInt8 ) :
                        {
                            if ( intVar.isSigned() )
                            {
                                return intValue.convertTo<hkInt8>();
                            }
                            else
                            {
                                return intValue.convertTo<hkUint8>();
                            }
                        }
                        case sizeof( hkInt16 ) :
                        {
                            if ( intVar.isSigned() )
                            {
                                return intValue.convertTo<hkInt16>();
                            }
                            else
                            {
                                return intValue.convertTo<hkUint16>();
                            }
                        }
                        case sizeof( hkInt32 ) :
                        {
                            if ( intVar.isSigned() )
                            {
                                return intValue.convertTo<hkInt32>();
                            }
                            else
                            {
                                return intValue.convertTo<hkUint32>();
                            }
                        }
                        default:
                        {
                            HK_ASSERT( 0x22441180, false, "Unsupported integer type" );
                            // Fall through to int64 since that's the underlying storage for IntValue
                        }
                        case sizeof( hkInt64 ) :
                        {
                            if ( intVar.isSigned() )
                            {
                                return intValue.convertTo<hkInt64>();
                            }
                            else
                            {
                                return intValue.convertTo<hkUint64>();
                            }
                        }
                    }
                }

                CLI::Object^ _ToCLI( hkReflect::FloatVar fltVar )
                {
                    switch ( fltVar.getType()->getSizeOf() )
                    {
                        case sizeof( hkHalf16 ) :
                        case sizeof( float ) :
                        {
                            return ( float ) fltVar.getValue();
                        }
                        default:
                        {
                            HK_ASSERT( 0x22441180, false, "Unsupported integer type" );
                            // Fall through to double since that's the underlying storage for IntValue
                        }
                        case sizeof( double ) :
                        {
                            return ( double ) fltVar.getValue();
                        }
                    }
                }

                
                
                
                extern CLI::Object^ ToCLI( const hkReflect::Var& var, bool raw )
                {
                    using namespace hkReflect;
                    bool useCustomTypes = !raw;

                    /////////////////
                    // Basic Common Types
                    /////////////////
                    if ( IntVar intVar = var )
                    {
                        return _ToCLI( intVar );
                    }
                    else if ( BoolVar boolVar = var )
                    {
                        return ( bool ) boolVar.getValue();
                    }
                    else if ( FloatVar fltVar = var )
                    {
                        return _ToCLI( fltVar );
                    }
                    else if ( StringVar strVar = var )
                    {
                        return Convert::String::ToCLI( strVar.getValue() );
                    }
                    /////////////////
                    // Custom Types
                    /////////////////
                    else if ( useCustomTypes )
                    {
                        if ( Havok::Reflect::Equals<hkVector4>( var.getType() ) )
                        {
                            if ( ArrayVar vecVar = var )
                            {
                                if ( vecVar.getCount() == 4 )
                                {
                                    FloatVar x = vecVar[0];
                                    FloatVar y = vecVar[1];
                                    FloatVar z = vecVar[2];
                                    FloatVar w = vecVar[3];

                                    HK_VDB_IF_MANAGED( return Havok::Vdb::Vector( x.getValue(), y.getValue(), z.getValue(), w.getValue() ); )
                                    HK_VDB_IF_NATIVE( return{ x.getValue(), y.getValue(), z.getValue(), w.getValue() } );
                                }
                            }

                            HK_ASSERT( 0x22441181, false, "Unexpected vector var type" );
                        }
                        else if ( hkString::strStr( var.getType()->getName(), hkReflect::getType<hkAabb>()->getName() ) != HK_NULL )
                        {
                            
                            if ( RecordVar recordVar = var )
                            {
                                if ( Havok::Reflect::Equals<hkAabb>( var.getType() ) )
                                {
                                    hkAabb* hkaabb = reinterpret_cast< hkAabb* >( var.getAddress() );
                                    return Convert::Aabb::ToCLI( *hkaabb );
                                }
                                //else if ( Havok::Reflect::Equals<hkAabbUint32>( var.getType() ) )
                                //{
                                //  hkAabbUtil::convertAabbFromUint32()
                                //}
                                else if ( Havok::Reflect::Equals<hkAabbHalf>( var.getType() ) )
                                {
                                    hkAabbHalf* hkaabbHalf = reinterpret_cast< hkAabbHalf* >( var.getAddress() );
                                    hkAabb* hkaabb = new hkAabb();
                                    hkaabbHalf->unpackUnaligned( *hkaabb );
                                    Havok::Vdb::Aabb cliaabb = Convert::Aabb::ToCLI( *hkaabb );
                                    delete hkaabb;
                                    return cliaabb;
                                }
                                //else if ( Havok::Reflect::Equals<hkAabb16>( var.getType() ) )
                                //{
                                //  hkAabb16* hkaabb16 = reinterpret_cast< hkAabb16* >( var.getAddress() );
                                //  hkAabb* hkaabb = new hkAabb();
                                //  hkIntSpaceUtil::restoreAabb( *hkaabb16, *hkaabb );
                                //  Havok::Vdb::Aabb cliaabb = Convert::Aabb::ToCLI( *hkaabb );
                                //  delete hkaabb;
                                //  return cliaabb;
                                //}
                                //else if ( Havok::Reflect::Equals<hkAabb24_16_24>( var.getType() ) )
                                //{
                                //}
                            }
                        }
                        else if ( Havok::Reflect::Equals<hkRotation>( var.getType() ) )
                        {
                            if ( ArrayVar rotVar = var )
                            {
                                if ( rotVar.getCount() == 12 )
                                {
                                    FloatVar col0x = rotVar[0];
                                    FloatVar col0y = rotVar[1];
                                    FloatVar col0z = rotVar[2];
                                    FloatVar col0w = rotVar[3];
                                    Havok::Vdb::Vector col0( col0x.getValue(), col0y.getValue(), col0z.getValue(), col0w.getValue() );
                                    FloatVar col1x = rotVar[4];
                                    FloatVar col1y = rotVar[5];
                                    FloatVar col1z = rotVar[6];
                                    FloatVar col1w = rotVar[7];
                                    Havok::Vdb::Vector col1( col1x.getValue(), col1y.getValue(), col1z.getValue(), col1w.getValue() );
                                    FloatVar col2x = rotVar[8];
                                    FloatVar col2y = rotVar[9];
                                    FloatVar col2z = rotVar[10];
                                    FloatVar col2w = rotVar[11];
                                    Havok::Vdb::Vector col2( col2x.getValue(), col2y.getValue(), col2z.getValue(), col2w.getValue() );

                                    HK_VDB_IF_MANAGED( return Havok::Vdb::Rotation( col0, col1, col2 ); )
                                    HK_VDB_IF_NATIVE( return{ col0, col1, col2 } );
                                }
                            }

                            HK_ASSERT( 0x22441182, false, "Unexpected rotation var type" );
                        }
                        else if ( Havok::Reflect::Equals<hkTransform>( var.getType() ) )
                        {
                            if ( ArrayVar tVar = var )
                            {
                                if ( tVar.getCount() == 16 )
                                {
                                    FloatVar col0x = tVar[0];
                                    FloatVar col0y = tVar[1];
                                    FloatVar col0z = tVar[2];
                                    FloatVar col0w = tVar[3];
                                    Havok::Vdb::Vector col0( col0x.getValue(), col0y.getValue(), col0z.getValue(), col0w.getValue() );
                                    FloatVar col1x = tVar[4];
                                    FloatVar col1y = tVar[5];
                                    FloatVar col1z = tVar[6];
                                    FloatVar col1w = tVar[7];
                                    Havok::Vdb::Vector col1( col1x.getValue(), col1y.getValue(), col1z.getValue(), col1w.getValue() );
                                    FloatVar col2x = tVar[8];
                                    FloatVar col2y = tVar[9];
                                    FloatVar col2z = tVar[10];
                                    FloatVar col2w = tVar[11];
                                    Havok::Vdb::Vector col2( col2x.getValue(), col2y.getValue(), col2z.getValue(), col2w.getValue() );
                                    Havok::Vdb::Rotation rotation( col0, col1, col2 );

                                    FloatVar x = tVar[12];
                                    FloatVar y = tVar[13];
                                    FloatVar z = tVar[14];
                                    FloatVar w = tVar[15];
                                    Havok::Vdb::Vector translation( x.getValue(), y.getValue(), z.getValue(), w.getValue() );

                                    HK_VDB_IF_MANAGED( return Havok::Vdb::Transform( translation, rotation ); )
                                    HK_VDB_IF_NATIVE( return{ translation, rotation } );
                                }
                            }

                            HK_ASSERT( 0x22441183, false, "Unexpected transform var type" );
                        }
                    }
                    /////////////////
                    // Fixed Arrays
                    /////////////////
                    // Note: *no* else if here because some of the custom types might bail and be caught be these specialized blocks
                    /*else */if ( ArrayVar arrayVar = var )
                    {
                        ArrayCLI<CLI::Object^>^ cliarray = clinew ArrayCLI<CLI::Object^>( arrayVar.getCount() );
                        for ( int i = 0; i < arrayVar.getCount(); i++ )
                        {
                            cliarray[i] = Convert::Object::ToCLI( arrayVar[i], raw );
                        }
                        return cliarray;
                    }
                    /////////////////
                    // Embedded Records
                    /////////////////
                    else if ( RecordVar recordVar = var )
                    {
                        return clinew NativeObject( recordVar );
                    }

                    /////////////////
                    // Final fallback
                    /////////////////
                    hkStringBuf fieldValue;
                    var.toString( fieldValue );
                    return Convert::String::ToCLI( fieldValue.cString() );
                }
            }
        }
    }
}

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
