// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbClient;
class hkVdbProgressReporter;

namespace Havok
{
    namespace Vdb
    {
        ref class ProgressReporter;

        public interface struct WorkEstimate
        {
            property hkUint32 CompletedWorkItems { hkUint32 get(); }
            property hkUint32 EstimatedWorkItems { hkUint32 get(); }
            property double EstimatedTimeRemaining { double get(); }
            property CLI::String^ Message { CLI::String^ get(); }
            property bool CanCancel { bool get(); }
            void Cancel();
        };
        public interface struct WorkEstimateUpdatedEventArgs : WorkEstimate {};

        public delegate void WorkEstimateUpdatedEventHandler( ProgressReporter^ sender, WorkEstimateUpdatedEventArgs^ args );

        public ref class ProgressReporter sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event WorkEstimateUpdatedEventHandler^ WorkEstimateUpdated;

        internal:

            void OnWorkEstimateUpdated( WorkEstimateUpdatedEventArgs^ args ) { WorkEstimateUpdated( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:
            property Havok::Vdb::WorkEstimate^ WorkEstimate { Havok::Vdb::WorkEstimate^ get() { return _WorkEstimate; } }

            property float UpdateFrequency;

            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            ProgressReporter( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( ProgressReporter );
            HK_VDB_DECLARE_UMDTOR( ProgressReporter );

        internal:

            Havok::Vdb::WorkEstimate^ _WorkEstimate;

        private:

            class ProgressReporterSignaler* m_signaler;
            hkVdbProgressReporter& m_progressReporter;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
