// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/ProgressReporter.h>

HK_VDB_MCLI_PP_PUSH_MANAGED( off )

#include HK_VDB_MCLI_INCLUDE( VisualDebugger/VdbServicesCLI/System/BaseSystem.h )

#include <Common/Base/System/Stopwatch/hkSystemClock.h>

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/hkVdbClient.h>
#include <VisualDebugger/VdbServices/System/hkVdbProgressReporter.h>

#define DEBUG_LOG_IDENTIFIER "vdb.ProgressReporter"
#include <Common/Base/System/Log/hkLog.hxx>

HK_VDB_MCLI_PP_SWITCH_MANAGED()

#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>

using namespace Havok::Vdb;

namespace Havok
{
    namespace Vdb
    {
        
        
        ref struct TotalWorkEstimateImpl : WorkEstimateUpdatedEventArgs
        {
            TotalWorkEstimateImpl( hkVdbProgressReporter& reporter ) :
                m_reporter( &reporter )
            {
                m_reporter->addReference();
            }
            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( TotalWorkEstimateImpl );
            HK_VDB_DECLARE_UMDTOR( TotalWorkEstimateImpl )
            {
                m_reporter->removeReference();
            }
            property virtual hkUint32 CompletedWorkItems;
            property virtual hkUint32 EstimatedWorkItems;
            property virtual double EstimatedTimeRemaining;
            property virtual CLI::String^ Message;
            property virtual bool CanCancel
            {
                bool get()
                {
                    // If we have anything cancellable, allow the frontend to cancel what we have...
                    // Anything uncancellable will just keep reporting (as if a new work task were created).
                    return m_reporter->getUninterruptibleWorkLoadCount() != m_reporter->getWorkLoadCount();
                }
            }
            virtual void Cancel()
            {
                // Cancel all we can cancel
                m_reporter->cancelAllWorkLoads();
            }
            hkVdbProgressReporter* m_reporter;
        };

        
        class ProgressReporterSignaler : public hkVdbDefaultErrorReporter
        {
        public:

            ProgressReporterSignaler( ProgressReporter^ target ) :
                hkVdbDefaultErrorReporter( &s_debugLog ),
                m_ticksPerSecond( hkSystemClock::getTicksPerSecond() ),
                m_nextUpdateTickCount( 0 ),
                m_target( target )
            {}

            void ProgressReporterSignaler::onEstUpdatedSignal( const hkVdbProgressReporter& reporter, hkUint64 id )
            {
                hkVdbProgressWorkEstimate estimate = reporter.getTotalEstimate();
                hkUint64 ticks = hkSystemClock::getTickCounter();
                if ( ( ticks > m_nextUpdateTickCount ) || ( estimate.m_estTimeRemaining == 0 ) )
                {
                    m_nextUpdateTickCount = ticks + hkUint64( m_ticksPerSecond * m_target->UpdateFrequency );

                    try
                    {
                        // We allow WorkEstimate to be used in the frontend to cancel the work of the reporter
                        // so we require const_cast.
                        TotalWorkEstimateImpl^ args = clinew TotalWorkEstimateImpl( const_cast<hkVdbProgressReporter&>( reporter ) );
                        {
                            args->CompletedWorkItems = estimate.m_completedWorkItems;
                            args->EstimatedWorkItems = estimate.m_estWorkItems;
                            args->EstimatedTimeRemaining = estimate.m_estTimeRemaining;
                            args->Message = Convert::String::ToCLI( reporter.getWorkMessage( id ) );
                        }
                        m_target->_WorkEstimate = args;
                        m_target->OnWorkEstimateUpdated( args );
                    }
                    catch ( CLI::Exception^ e )
                    {
                        HK_VDB_SIGNAL_ERROR_MSG(
                            0xfdb00021,
                            hkVdbError::CMD_HANDLER_ERROR,
                            "Signaler encountered exception: " << hkUtf8::Utf8FromWide( e->Message ).cString() );
                    }
                }
            }

        private:

            hkUint64 m_ticksPerSecond;
            hkUint64 m_nextUpdateTickCount;
            WeakCLIPtr<ProgressReporter^> m_target;
        };
    }
}

ProgressReporter::ProgressReporter( hkVdbClient& client ) :
    m_progressReporter( client.getProgressReporter() )
{
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->addReference(); )
    {
        TotalWorkEstimateImpl^ estimate = clinew TotalWorkEstimateImpl( m_progressReporter );
        hkVdbProgressWorkEstimate hkestimate = m_progressReporter.getTotalEstimate();
        estimate->CompletedWorkItems = hkestimate.m_completedWorkItems;
        estimate->EstimatedWorkItems = hkestimate.m_estWorkItems;
        estimate->EstimatedTimeRemaining = hkestimate.m_estTimeRemaining;
        _WorkEstimate = estimate;
    }
    m_signaler = new ProgressReporterSignaler( this );
    HK_SUBSCRIBE_TO_SIGNAL( m_progressReporter.m_estUpdated, m_signaler, ProgressReporterSignaler );
    m_progressReporter.addReference();
}

HK_VDB_DEFINE_UMDTOR( ProgressReporter )
{
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->initGCThread(); )
    m_progressReporter.m_estUpdated.unsubscribeAll( m_signaler );
    delete m_signaler;
    m_progressReporter.removeReference();
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->removeReference(); )
}

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
