// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbClient;
class hkVdbTextHandler;

namespace Havok
{
    namespace Vdb
    {
        ref class TextHandler;

        public enum class LogLevel
        {
            Error = 1,
            Warning,
            Info,
            Dev,
            Debug
        };

        public enum class LogSource
        {
            Server,
            Client
        };

        public ref struct TextCmdReceivedArgs sealed
        {
        public:
            property hkUint64 Id { hkUint64 get() { return _Id; } }
            property int Tag { int get() { return _Tag; } }
            property LogLevel Level { LogLevel get() { return _Level; } }
            property CLI::String^ Text { CLI::String^ get() { return _Text; } }
            property LogSource Source { LogSource get() { return _Source; } }
        internal:
            hkUint64 _Id;
            int _Tag;
            LogLevel _Level;
            CLI::String^ _Text;
            LogSource _Source;
        };

        public delegate void TextCmdReceivedHandler( TextHandler^ sender, TextCmdReceivedArgs^ args );

        public ref class TextHandler sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event TextCmdReceivedHandler^ TextCmdReceived;

        internal:

            void OnTextCmdReceived( TextCmdReceivedArgs^ args ) { TextCmdReceived( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:
            

            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            TextHandler( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( TextHandler );
            HK_VDB_DECLARE_UMDTOR( TextHandler );

        private:

            HK_VDB_IF_MANAGED( void OnApplicationExit( System::Object^ sender, System::Windows::ExitEventArgs^ e ); )

            class TextHandlerSignaler* m_signaler;

            hkVdbTextHandler& m_textHandler;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
