// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbClient;
class hkVdbStatsHandler;

namespace Havok
{
    namespace Vdb
    {
        ref class StatsHandler;

        // Currently, setting properties on a timer node *only* affect the stat line graph.
        public interface struct ITimerNode
        {
            [MetadataCLI::Flags]
            enum class EnabledFlags : unsigned int
            {
                // These can't currently be disabled
                StatText = ( 1 << 0 ),
                DeprecatedStatBarGraph = ( 1 << 1 ),
                StatBarGraph = ( 1 << 2 ),
                StatLineGraph = ( 1 << 3 ),
                Default = ( StatText | DeprecatedStatBarGraph | StatBarGraph )
            };
            property CLI::String^ Path { CLI::String^ get(); }
            property CLI::String^ Name { CLI::String^ get(); }
            property float ValueSum { float get(); }
            property unsigned int CountSum { unsigned int get(); }
            property unsigned int TotalChildCallCount { unsigned int get(); }
            property ReadOnlyListCLI<float>^ ThreadData { ReadOnlyListCLI<float>^ get(); };
            property ReadOnlyListCLI<hkUint32>^ ThreadDataCount { ReadOnlyListCLI<hkUint32>^ get(); };
            property EnabledFlags Enabled;
            property ColorCLI Color;
            property ReadOnlyListCLI<ITimerNode^>^ Children { ReadOnlyListCLI<ITimerNode^>^ get(); };
            ITimerNode^ FindChild( CLI::String^ pathToNode );
            ITimerNode^ FindOrCreateChild( CLI::String^ pathToNode );
        };

        public ref class PerfStatsReceivedEventArgs sealed
        {
        public:
            property ITimerNode^ RootTimerNode { ITimerNode^ get() { return _RootTimerNode; } }
        internal:
            ITimerNode^ _RootTimerNode;
        };
        public delegate void PerfStatsReceivedEventHandler( StatsHandler^ sender, PerfStatsReceivedEventArgs^ args );

        public ref class MemStatsReceivedEventArgs sealed
        {
        public:
        internal:
        };
        public delegate void MemStatsReceivedEventHandler( StatsHandler^ sender, MemStatsReceivedEventArgs^ args );

        public ref class FrameStatsReceivedEventArgs sealed
        {
        public:
            property hkUint64 FrameCount { hkUint64 get() { return _Count; } }
            property hkUint16 SampleWindowSize { hkUint16 get() { return _SampleWindowSize; } }
            property double Mean { double get() { return _Mean; } }
            property double Median { double get() { return _Median; } }
            property double StandardDeviation { double get() { return _StandardDeviation; } }
            property double Max { double get() { return _Max; } }
            property double Min { double get() { return _Min; } }
            property double StepMean { double get() { return _StepMean; } }
            property double StepMedian { double get() { return _StepMedian; } }
            property double StepStandardDeviation { double get() { return _StepStandardDeviation; } }
            property double StepMax { double get() { return _StepMax; } }
            property double StepMin { double get() { return _StepMin; } }
            property double LastStepElapsedSeconds { double get() { return _LastStepElapsedSeconds; } }
        internal:
            hkUint64 _Count;
            hkUint16 _SampleWindowSize;
            double _Mean;
            double _Median;
            double _StandardDeviation;
            double _Max;
            double _Min;
            double _StepMean;
            double _StepMedian;
            double _StepStandardDeviation;
            double _StepMax;
            double _StepMin;
            double _LastStepElapsedSeconds;
        };
        public delegate void FrameStatsReceivedEventHandler( StatsHandler^ sender, FrameStatsReceivedEventArgs^ args );

        public ref class StatsHandler sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event PerfStatsReceivedEventHandler^ PerfStatsReceived;
            event MemStatsReceivedEventHandler^ MemStatsReceived;
            event FrameStatsReceivedEventHandler^ FrameStatsReceived;

        internal:

            void OnPerfStatsReceived( PerfStatsReceivedEventArgs^ args ) { PerfStatsReceived( this, args ); }
            void OnMemStatsReceived( MemStatsReceivedEventArgs^ args ) { MemStatsReceived( this, args ); }
            void OnFrameStatsReceived( FrameStatsReceivedEventArgs^ args ) { FrameStatsReceived( this, args ); }

            delegate void TimerNodeChangedEventHandler( StatsHandler^ sender, ITimerNode^ args );
            event TimerNodeChangedEventHandler^ TimerNodeChanged;
            void OnTimerNodeChanged( ITimerNode^ args ) { TimerNodeChanged( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:
            property unsigned short FrameSampleWindowSize
            {
                unsigned short get();
                void set( unsigned short windowSize );
            }
            property PerfStatsReceivedEventArgs^ PerfStats
            {
                PerfStatsReceivedEventArgs^ get() { return m_perfStats; }
            }
            property MemStatsReceivedEventArgs^ MemStats
            {
                MemStatsReceivedEventArgs^ get() { return m_memStats; }
            }
            property FrameStatsReceivedEventArgs^ FrameStats
            {
                FrameStatsReceivedEventArgs^ get() { return m_frameStats; }
            }

            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            StatsHandler( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( StatsHandler );
            HK_VDB_DECLARE_UMDTOR( StatsHandler );

        internal:

            PerfStatsReceivedEventArgs^ m_perfStats;
            MemStatsReceivedEventArgs^ m_memStats;
            FrameStatsReceivedEventArgs^ m_frameStats;

            ref struct TimerNodeState
            {
                property Havok::Vdb::ITimerNode::EnabledFlags Enabled;
                property ColorCLI Color;
            };
            TimerNodeState^ GetOrCreateTimerState( ITimerNode^ node );
            MapCLIImpl<CLI::String^, TimerNodeState^>^ m_timerPathToStateMap;

        private:

            class StatsHandlerSignaler* m_signaler;

            hkVdbStatsHandler& m_statsHandler;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
