// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/Handlers/StatsHandler.h>

HK_VDB_MCLI_PP_PUSH_MANAGED( off )

#include HK_VDB_MCLI_INCLUDE( VisualDebugger/VdbServicesCLI/System/BaseSystem.h )

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Serialize/hkVdbIStream.h>

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/hkVdbClient.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbStatsHandler.h>

#define DEBUG_LOG_IDENTIFIER "vdb.StatsHandler"
#include <Common/Base/System/Log/hkLog.hxx>

HK_VDB_MCLI_PP_SWITCH_MANAGED()

#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>

using namespace Havok::Vdb;
typedef hkVdbStatsHandler::PerfStats PerfStats;
typedef hkVdbStatsHandler::MemStats MemStats;
typedef hkVdbStatsHandler::FrameStats FrameStats;

namespace Havok
{
    namespace Vdb
    {
        ref class TimerNode : ITimerNode
        {
        protected:
            TimerNode(
                StatsHandler^ handler) :
                m_handler( handler )
            {}
        public:
            TimerNode(
                StatsHandler^ handler,
                const hkMonitorStreamAnalyzer::Node* node ) :
                m_handler( handler ),
                m_node( node )
            {
                m_state = handler->GetOrCreateTimerState( this );
            }
            property CLI::String^ Path { virtual CLI::String^ get() { return ConstructPath( m_node ); } }
            property CLI::String^ Name { virtual CLI::String^ get() { return Convert::String::ToCLI( ( m_node && m_node->m_parent ) ? m_node->m_name : "" ); } }
            property float ValueSum { virtual float get() { return ( m_node != HK_NULL ) ? m_node->valuesSum() : 0; } }
            property unsigned int CountSum { virtual unsigned int get() { return ( m_node != HK_NULL ) ? m_node->countsSum() : 0; } }
            property unsigned int TotalChildCallCount { virtual unsigned int get() { return ( m_node != HK_NULL ) ? m_node->m_totalCallCountForChildren : 0; } }
            property ReadOnlyListCLI<float>^ ThreadData
            {
                virtual ReadOnlyListCLI<float>^ get()
                {
                    if( _ThreadData == nullptr )
                    {
                        _ThreadData = clinew ListCLIImpl<float>();
                        if( m_node )
                        {
                            for( int i = 0; i < m_node->m_threadData.getSize(); i++ )
                            {
                                const hkMonitorStreamAnalyzer::Node::ThreadData& threadData = m_node->m_threadData[i];
                                _ThreadData->Add( threadData.m_value );
                            }
                        }
                    }
                    return Convert::Array::ToCLIReadOnly( _ThreadData );
                }
            }

            property ReadOnlyListCLI<hkUint32>^ ThreadDataCount
            {
                virtual ReadOnlyListCLI<hkUint32>^ get()
                {
                    if( _ThreadDataCount == nullptr )
                    {
                        _ThreadDataCount = clinew ListCLIImpl<hkUint32>();
                        if( m_node )
                        {
                            for( int i = 0; i < m_node->m_threadData.getSize(); i++ )
                            {
                                const hkMonitorStreamAnalyzer::Node::ThreadData& threadData = m_node->m_threadData[i];
                                _ThreadDataCount->Add( threadData.m_count );
                            }
                        }
                    }
                    return Convert::Array::ToCLIReadOnly( _ThreadDataCount );
                }
            }

            property ITimerNode::EnabledFlags Enabled
            {
                virtual ITimerNode::EnabledFlags get() { return m_state->Enabled; }
                virtual void set( ITimerNode::EnabledFlags flags )
                {
                    if ( m_state->Enabled != flags )
                    {
                        m_state->Enabled = flags;
                        m_handler->OnTimerNodeChanged( this );
                    }
                }
            }
            property ColorCLI Color
            {
                virtual ColorCLI get() { return m_state->Color; }
                virtual void set( ColorCLI color )
                {
                    if ( m_state->Color != color )
                    {
                        m_state->Color = color;
                        m_handler->OnTimerNodeChanged( this );
                    }
                }
            }
            property ReadOnlyListCLI<ITimerNode^>^ Children
            {
                virtual ReadOnlyListCLI<ITimerNode^>^ get()
                {
                    if ( _Children == nullptr )
                    {
                        _Children = clinew ListCLIImpl<ITimerNode^>();
                        if ( m_node )
                        {
                            for ( int i = 0; i < m_node->m_children.getSize(); i++ )
                            {
                                _Children->Add(
                                    clinew TimerNode(
                                        m_handler,
                                        m_node->m_children[i] ) );
                            }
                        }
                    }
                    return Convert::Array::ToCLIReadOnly( _Children );
                }
            }
            virtual ITimerNode^ FindChild( CLI::String^ pathToNode )
            {
                if ( m_node )
                {
                    hkStringBuf hkstorage;
                    if ( const hkMonitorStreamAnalyzer::Node* child = m_node->findChild( Convert::String::FromCLI( pathToNode, hkstorage ) ) )
                    {
                        return clinew TimerNode(
                            m_handler,
                            child );
                    }
                }
                return nullptr;
            }
            virtual ITimerNode^ FindOrCreateChild( CLI::String^ pathToNode );
        protected:
            static CLI::String^ ConstructPath( const hkMonitorStreamAnalyzer::Node* node )
            {
                hkStringBuf path;
                if ( node )
                {
                    node->getPath( path );
                    while ( ( path.getLength() > 0 ) && ( path[0] == '/' ) ) path.chompStart( 1 );
                }
                return Convert::String::ToCLI( path );
            }
            StatsHandler^ m_handler;
            Havok::Vdb::StatsHandler::TimerNodeState^ m_state;
            const hkMonitorStreamAnalyzer::Node* m_node;
            ListCLI<ITimerNode^>^ _Children;
            ListCLI<float>^ _ThreadData;
            ListCLI<hkUint32>^ _ThreadDataCount;
        };

        ref class TimerNodeProxy : TimerNode
        {
        public:
            TimerNodeProxy(
                StatsHandler^ handler,
                CLI::String^ fullPathAndName ) :
                TimerNode( handler ),
                _Path( "" ),
                _Name( "" )
            {
                if ( fullPathAndName != nullptr )
                {
                    int idx = fullPathAndName->LastIndexOf( '/' );
                    if ( idx != -1 )
                    {
                        _Path = fullPathAndName->Substring( 0, idx + 1 );
                        _Name = fullPathAndName->Substring( idx + 1 );
                    }
                    else
                    {
                        _Name = fullPathAndName;
                    }
                }
                m_state = handler->GetOrCreateTimerState( this );
            }
            property CLI::String^ Path { virtual CLI::String^ get() override { return _Path; } }
            property CLI::String^ Name { virtual CLI::String^ get() override { return _Name; } }
        protected:
            CLI::String^ _Path;
            CLI::String^ _Name;
        };

        ITimerNode^ TimerNode::FindOrCreateChild( CLI::String^ pathToNode )
        {
            ITimerNode^ child = FindChild( pathToNode );
            if ( child == nullptr )
            {
                child = clinew TimerNodeProxy( m_handler, Path + pathToNode );
            }
            return child;
        }

        class StatsHandlerSignaler : public hkVdbDefaultErrorReporter
        {
        public:

            StatsHandlerSignaler( StatsHandler^ target ) :
                hkVdbDefaultErrorReporter( &s_debugLog ),
                m_target( target )
            {}

            
            
            
            

            void StatsHandlerSignaler::onPerfStatsReceivedSignal( const PerfStats& stats, hkVdbSignalResult& result )
            {
                try
                {
                    PerfStatsReceivedEventArgs^ args = clinew PerfStatsReceivedEventArgs();
                    {
                        args->_RootTimerNode = clinew TimerNode(
                            m_target,
                            &stats.m_statsTree );
                    }
                    m_target->OnPerfStatsReceived( args );
                    m_target->m_perfStats = args;
                }
                catch ( CLI::Exception^ e )
                {
                    HK_VDB_SIGNAL_ERROR_MSG(
                        0xfdb00018,
                        hkVdbError::CMD_HANDLER_ERROR,
                        "Signaler encountered exception: " << hkUtf8::Utf8FromWide( e->Message ).cString() );

                    result.signalError( *this );
                }
            }

            void StatsHandlerSignaler::onMemStatsReceivedSignal( const MemStats&, hkVdbSignalResult& result )
            {
                try
                {
                    
                }
                catch ( CLI::Exception^ e )
                {
                    HK_VDB_SIGNAL_ERROR_MSG(
                        0xfdb00019,
                        hkVdbError::CMD_HANDLER_ERROR,
                        "Signaler encountered exception: " << hkUtf8::Utf8FromWide( e->Message ).cString() );

                    result.signalError( *this );
                }
            }

            void StatsHandlerSignaler::onFrameStatsUpdatedSignal( const FrameStats& stats )
            {
                try
                {
                    if ( stats.getStepStats().getNumSamples() > 0 )
                    {
                        FrameStatsReceivedEventArgs^ args = clinew FrameStatsReceivedEventArgs();
                        {
                            args->_Count = stats.getNumFrames();
                            args->_SampleWindowSize = stats.getStepStats().getWindowSize();
                            args->_Mean = stats.getStepStats().getWindowedMean();
                            args->_Median = stats.getStepStats().getWindowedMedian();
                            args->_StandardDeviation = stats.getStepStats().getWindowedStandardDeviation();
                            args->_Max = stats.getStepStats().getWindowedMax();
                            args->_Min = stats.getStepStats().getWindowedMin();
                            args->_StepMean = stats.getVdbStepStats().getWindowedMean();
                            args->_StepMedian = stats.getVdbStepStats().getWindowedMedian();
                            args->_StepStandardDeviation = stats.getVdbStepStats().getWindowedStandardDeviation();
                            args->_StepMax = stats.getVdbStepStats().getWindowedMax();
                            args->_StepMin = stats.getVdbStepStats().getWindowedMin();
                            args->_LastStepElapsedSeconds = stats.getLastStepElapsedSeconds();
                        }
                        m_target->OnFrameStatsReceived( args );
                        m_target->m_frameStats = args;
                    }
                }
                catch ( CLI::Exception^ e )
                {
                    HK_VDB_SIGNAL_ERROR_MSG(
                        0xfdb00006,
                        hkVdbError::CMD_HANDLER_ERROR,
                        "Signaler encountered exception: " << hkUtf8::Utf8FromWide( e->Message ).cString() );

                    // No signal return so we can't bubble up, so just report
                    reportError();
                }
            }

        private:

            WeakCLIPtr<StatsHandler^> m_target;
        };
    }
}

hkUint16 StatsHandler::FrameSampleWindowSize::get()
{
    return m_statsHandler.getFrameSampleWindowSize();
}

void StatsHandler::FrameSampleWindowSize::set( hkUint16 windowSize )
{
    m_statsHandler.setFrameSampleWindowSize( windowSize );
}

StatsHandler::StatsHandler( hkVdbClient& client ) :
    m_statsHandler( *client.getCmdHandler<hkVdbStatsHandler>() )
{
    m_timerPathToStateMap = clinew MapCLIImpl<CLI::String^, TimerNodeState^>();
    m_perfStats = clinew PerfStatsReceivedEventArgs();
    m_perfStats->_RootTimerNode = clinew TimerNodeProxy( this, nullptr );
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->addReference(); )
    m_signaler = new StatsHandlerSignaler( this );
    HK_SUBSCRIBE_TO_SIGNAL( m_statsHandler.m_perfStatsReceived, m_signaler, StatsHandlerSignaler );
    //HK_SUBSCRIBE_TO_SIGNAL( m_statsHandler.m_memStatsReceived, m_signaler, StatsHandlerSignaler );
    HK_SUBSCRIBE_TO_SIGNAL( m_statsHandler.m_frameStatsUpdated, m_signaler, StatsHandlerSignaler );
    m_statsHandler.addReference();
}

StatsHandler::TimerNodeState^ StatsHandler::GetOrCreateTimerState( ITimerNode^ node )
{
    CLI::String^ fullNodePath = ( node->Path + node->Name );
    StatsHandler::TimerNodeState^ state;
    if ( !m_timerPathToStateMap->TryGetValue( fullNodePath, state ) )
    {
        state = clinew TimerNodeState();
        state->Enabled = ITimerNode::EnabledFlags::Default;

        // Select a "random" hue
        static int hue = 0;
        hkColor::Argb color = hkColor::rgbFromHSV( hue / 256.0f, 0.6f, 1.0f );
        hue = (hue + 77) % 256; // we want it reasonably different each time but also try to not reuse values when wrapping around
        state->Color = Convert::Color::ToCLI<hkColor::Argb, ColorCLI>( color );

        m_timerPathToStateMap->Add( fullNodePath, state );
    }
    return state;
}

HK_VDB_DEFINE_UMDTOR( StatsHandler )
{
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->initGCThread(); )
    m_statsHandler.m_perfStatsReceived.unsubscribeAll( m_signaler );
    //m_statsHandler.m_memStatsReceived.unsubscribeAll( m_signaler );
    m_statsHandler.m_frameStatsUpdated.unsubscribeAll( m_signaler );
    delete m_signaler;
    m_statsHandler.removeReference();
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->removeReference(); )
}

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
