// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbClient;
class hkVdbSetupHandler;

namespace Havok
{
    namespace Vdb
    {
        ref class SetupHandler;

        [MetadataCLI::Flags]
        public enum class Capabilities : unsigned int
        {
            None = 0,
            Unknown = ( 1 << 0 ),
            SaveCommandInputBuffer = ( 1 << 1 ),
            QuickStartRecording = ( 1 << 2 ),
        };

        public interface struct SetupInfo
        {
            property int Protocol { int get(); }
            property int MinProtocol { int get(); }
            property int SdkVersion { int get(); }
            property CLI::String^ PlatformString { CLI::String^ get(); }
            property CLI::String^ CompilerString { CLI::String^ get(); }
            property int PointerSize { int get(); }
            property bool IsLittleEndian { bool get(); }
        };

        public ref class SetupHandlerEventArgs sealed
        {
        public:
            property Havok::Vdb::SetupInfo^ ClientInfo { Havok::Vdb::SetupInfo^ get() { return _ClientInfo; } }
            property Havok::Vdb::SetupInfo^ ServerInfo { Havok::Vdb::SetupInfo^ get() { return _ServerInfo; } }
            property Havok::Vdb::Capabilities Capabilities { Havok::Vdb::Capabilities get() { return _Capabilities; } }
        internal:
            Havok::Vdb::SetupInfo^ _ClientInfo;
            Havok::Vdb::SetupInfo^ _ServerInfo;
            Havok::Vdb::Capabilities _Capabilities = Havok::Vdb::Capabilities::Unknown;
        };
        public delegate void SetupHandlerEventHandler( SetupHandler^ sender, SetupHandlerEventArgs^ args );

        public ref class SetupHandler sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event SetupHandlerEventHandler^ ServerInfoReceived;

        internal:

            void OnServerInfoReceived( SetupHandlerEventArgs^ args ) { ServerInfoReceived( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:
            property Havok::Vdb::SetupHandlerEventArgs^ SetupInfo { Havok::Vdb::SetupHandlerEventArgs^ get() { return m_setupInfo; } }


            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            SetupHandler( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( SetupHandler );
            HK_VDB_DECLARE_UMDTOR( SetupHandler );

        internal:

            SetupHandlerEventArgs^ m_setupInfo;

        private:

            class SetupHandlerSignaler* m_signaler;

            hkVdbClient& m_client;
            hkVdbSetupHandler& m_setupHandler;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
