// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/Handlers/SetupHandler.h>

HK_VDB_MCLI_PP_PUSH_MANAGED( off )

#include HK_VDB_MCLI_INCLUDE( VisualDebugger/VdbServicesCLI/System/BaseSystem.h )

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Serialize/hkVdbIStream.h>

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/hkVdbClient.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbSetupHandler.h>

#define DEBUG_LOG_IDENTIFIER "vdb.SetupHandler"
#include <Common/Base/System/Log/hkLog.hxx>

HK_VDB_MCLI_PP_SWITCH_MANAGED()

#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>

using namespace Havok::Vdb;


namespace Havok
{
    namespace Vdb
    {
        ref struct SetupInfoImpl : SetupInfo
        {
            property int Protocol { virtual int get() { return _Protocol; } }
            property int MinProtocol { virtual int get() { return _MinProtocol; } }
            property int SdkVersion { virtual int get() { return _SdkVersion; } }
            property CLI::String^ PlatformString { virtual CLI::String^ get() { return _PlatformString; } }
            property CLI::String^ CompilerString { virtual CLI::String^ get() { return _CompilerString; } }
            property int PointerSize { virtual int get() { return _PointerSize; } }
            property bool IsLittleEndian { virtual bool get() { return _IsLittleEndian; } }
        internal:
            int _Protocol;
            int _MinProtocol;
            int _SdkVersion;
            CLI::String^ _PlatformString;
            CLI::String^ _CompilerString;
            int _PointerSize;
            bool _IsLittleEndian;
        };

        class SetupHandlerSignaler : public hkVdbDefaultErrorReporter
        {
        public:

            SetupHandlerSignaler( SetupHandler^ target, hkVdbSetupHandler& handler ) :
                hkVdbDefaultErrorReporter( &s_debugLog ),
                m_handler( handler ),
                m_target( target )
            {
                m_target->m_setupInfo = clinew SetupHandlerEventArgs();

                // Initialize client stuff which we should know already
                hkVdbSetupHandler::ClientInfo clientInfo;
                m_handler.getClientInfo( clientInfo );
                m_target->m_setupInfo->_ClientInfo = extractInfo( clientInfo );
            }

            void SetupHandlerSignaler::onServerInfoReceivedSignal(
                const hkVdbSetupHandler::ClientInfo& clientInfo,
                const hkVdbSetupHandler::ServerInfo& serverInfo,
                hkVdbCapabilities capabilities,
                hkVdbSignalResult& result )
            {
                try
                {
                    SetupHandlerEventArgs^ args = clinew SetupHandlerEventArgs();
                    {
                        args->_ClientInfo = extractInfo( clientInfo );
                        args->_ServerInfo = extractInfo( serverInfo );
                        args->_Capabilities = Convert::Flags::ToCLI<hkVdbCapabilities, Havok::Vdb::Capabilities>( capabilities );
                    }
                    m_target->m_setupInfo = args;
                    m_target->OnServerInfoReceived( args );
                }
                catch ( CLI::Exception^ e )
                {
                    HK_VDB_SIGNAL_ERROR_MSG(
                        0xfdb00002,
                        hkVdbError::CMD_HANDLER_ERROR,
                        "Signaler encountered exception: " << hkUtf8::Utf8FromWide( e->Message ).cString() );

                    // Bubble up via signal result
                    result.signalError( *this );
                }
            }

            SetupInfoImpl^ extractInfo( const hkVersionReporter::Info& info )
            {
                SetupInfoImpl^ cliinfo = clinew SetupInfoImpl();
                cliinfo->_Protocol = info.m_protocol;
                cliinfo->_MinProtocol = info.m_minimumProtocol;
                cliinfo->_SdkVersion = info.m_sdkVersion;
                cliinfo->_PlatformString = Convert::String::ToCLI( info.m_platformString );
                cliinfo->_CompilerString = Convert::String::ToCLI( info.m_compilerString );
                cliinfo->_PointerSize = info.m_sizeOfPointer;
                cliinfo->_IsLittleEndian = info.m_isLittleEndian;
                return cliinfo;
            }

        private:

            hkVdbSetupHandler& m_handler;
            WeakCLIPtr<SetupHandler^> m_target;
        };
    }
}

SetupHandler::SetupHandler( hkVdbClient& client ) :
    m_client( client ),
    m_setupHandler( *client.getCmdHandler<hkVdbSetupHandler>() )
{
    m_setupInfo = clinew SetupHandlerEventArgs();
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->addReference(); )
    m_signaler = new SetupHandlerSignaler( this, m_setupHandler );
    HK_SUBSCRIBE_TO_SIGNAL( m_setupHandler.m_serverInfoReceived, m_signaler, SetupHandlerSignaler );
    m_client.addReference();
    m_setupHandler.addReference();

    // Test enum/flag conversions, this won't test if there are new members that we aren't handling.
    // That is handled by Convert::Enum/Flag::ToCLI().
#ifdef HK_DEBUG
#if defined(HK_VDB_CLI_MANAGED)
    CLI::String^ name;
    name = CLI::Enum::GetName( Havok::Vdb::Capabilities::typeid, clinew CLI::Int32( hkVdbCapabilities::NONE ) );
    HK_ASSERT_NO_MSG( 0x22441091, name->ToUpper()->Equals( "NONE" ) );
    name = CLI::Enum::GetName( Havok::Vdb::Capabilities::typeid, clinew CLI::Int32( hkVdbCapabilities::UNKNOWN ) );
    HK_ASSERT_NO_MSG( 0x22441095, name->ToUpper()->Equals( "UNKNOWN" ) );
    name = CLI::Enum::GetName( Havok::Vdb::Capabilities::typeid, clinew CLI::Int32( hkVdbCapabilities::SAVE_CMD_INPUT_BUFFER ) );
    HK_ASSERT_NO_MSG( 0x22441092, name->ToUpper()->Equals( "SAVECOMMANDINPUTBUFFER" ) );
    name = CLI::Enum::GetName( Havok::Vdb::Capabilities::typeid, clinew CLI::Int32( hkVdbCapabilities::QUICK_START_RECORDING ) );
    HK_ASSERT_NO_MSG( 0x22441093, name->ToUpper()->Equals( "QUICKSTARTRECORDING" ) );
#endif
#endif
}

HK_VDB_DEFINE_UMDTOR( SetupHandler )
{
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->initGCThread(); )
    m_setupHandler.m_serverInfoReceived.unsubscribeAll( m_signaler );
    delete m_signaler;
    m_client.removeReference();
    m_setupHandler.removeReference();
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->removeReference(); )
}

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
