// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbClient;
class hkVdbProcessHandler;

namespace Havok
{
    namespace Vdb
    {
        ref class ProcessHandler;

        public interface class ProcessEventArgs
        {
        public:
            property int Tag { int get(); }
        };

        public ref class ProcessRegisteredEventArgs sealed : public ProcessEventArgs
        {
        public:
            property int Tag { virtual int get() { return _Tag; } }
            property CLI::String^ Name { CLI::String^ get() { return _Name; } }
        internal:
            int _Tag;
            CLI::String^ _Name;
        };
        public delegate void ProcessRegisteredEventHandler( ProcessHandler^ sender, ProcessRegisteredEventArgs^ args );

        public ref class ProcessUpdatedEventArgs sealed : public ProcessEventArgs
        {
        public:
            property int Tag { virtual int get() { return _Tag; } }
        internal:
            int _Tag;
        };
        public delegate void ProcessUpdatedEventHandler( ProcessHandler^ sender, ProcessUpdatedEventArgs^ args );

        public ref class ProcessSelectionChangedEventArgs sealed : public ProcessEventArgs
        {
        public:
            property int Tag { virtual int get() { return _Tag; } }
            property bool Selected { bool get() { return _Selected; } }
        internal:
            int _Tag;
            bool _Selected;
        };
        public delegate void ProcessSelectionChangedEventHandler( ProcessHandler^ sender, ProcessSelectionChangedEventArgs^ args );

        public ref class Process sealed
        {
        public:
            property int Tag { int get() { return _Tag; } }
            property CLI::String^ Name { CLI::String^ get() { return _Name; } }
            property bool Selected
            {
                bool get();
                void set( bool selected );
            }

        internal:
            Process( hkVdbProcessHandler& processHandler ) :
                m_processHandler( processHandler )
            {}
            int _Tag;
            CLI::String^ _Name;
            hkVdbProcessHandler& m_processHandler;
        };

        public ref class ProcessHandler sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event ProcessRegisteredEventHandler^ ProcessRegistered;
            event ProcessUpdatedEventHandler^ ProcessUpdated;
            event ProcessSelectionChangedEventHandler^ ProcessSelectionChanged;

        internal:

            void OnProcessRegistered( ProcessRegisteredEventArgs^ args ) { ProcessRegistered( this, args ); }
            void OnProcessUpdated( ProcessUpdatedEventArgs^ args ) { ProcessUpdated( this, args ); }
            void OnProcessSelectionChanged( ProcessSelectionChangedEventArgs^ args ) { ProcessSelectionChanged( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:

            Process^ GetProcess( int tag );
            HK_VDB_IF_NATIVE( [Windows::Foundation::Metadata::DefaultOverload] )
            Process^ GetProcess( CLI::String^ name );

            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            ProcessHandler( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( ProcessHandler );
            HK_VDB_DECLARE_UMDTOR( ProcessHandler );

        private:

            class ProcessHandlerSignaler* m_signaler;

            hkVdbProcessHandler& m_processHandler;
        };
    }
}


#if false
ref class ProcessRegisteredEventArgs;
ref class ProcessUpdatedEventArgs;
public interface class ProcessEventArgs
{
public:
    property int Tag { int get(); }
    property CLI::String^ Name { CLI::String^ get(); }
    ProcessRegisteredEventArgs^ asRegisteredEventArgs();
    ProcessUpdatedEventArgs^ asUpdatedEventArgs();
};

public ref class ProcessRegisteredEventArgs sealed : public ProcessEventArgs
{
public:
    property int Tag { virtual int get() { return _Tag; } }
    property CLI::String^ Name { virtual CLI::String^ get() { return _Name; } }
    virtual ProcessRegisteredEventArgs^ asRegisteredEventArgs() { return this; }
    virtual ProcessUpdatedEventArgs^ asUpdatedEventArgs() { return nullptr; }
internal:
    int _Tag;
    CLI::String^ _Name;
};
public delegate void ProcessRegisteredEventHandler( ProcessHandler^ sender, ProcessEventArgs^ args );
#endif

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
