// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/Handlers/ProcessHandler.h>

HK_VDB_MCLI_PP_PUSH_MANAGED( off )

#include HK_VDB_MCLI_INCLUDE( VisualDebugger/VdbServicesCLI/System/BaseSystem.h )

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Serialize/hkVdbIStream.h>

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/hkVdbClient.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbProcessHandler.h>

#define DEBUG_LOG_IDENTIFIER "vdb.ProcessHandler"
#include <Common/Base/System/Log/hkLog.hxx>

HK_VDB_MCLI_PP_SWITCH_MANAGED()

#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>

using namespace Havok::Vdb;
typedef hkVdbProcessHandler::ProcessCmd ProcessCmd;
typedef hkVdbProcessHandler::ProcessRegisteredCmd ProcessRegisteredCmd;
typedef hkVdbProcessHandler::ProcessUpdatedCmd ProcessUpdatedCmd;
typedef hkVdbProcessHandler::ProcessSelectionChangedCmd ProcessSelectionChangedCmd;

namespace Havok
{
    namespace Vdb
    {
        class ProcessHandlerSignaler : public hkVdbDefaultErrorReporter
        {
        public:

            ProcessHandlerSignaler( ProcessHandler^ target ) :
                hkVdbDefaultErrorReporter( &s_debugLog ),
                m_target( target )
            {}

            void ProcessHandlerSignaler::onProcessCmdReceivedSignal( const ProcessCmd& cmd, hkVdbSignalResult& result )
            {
                try
                {
                    if ( const ProcessRegisteredCmd* regCmd = cmd.asRegisteredCmd() )
                    {
                        ProcessRegisteredEventArgs^ args = clinew ProcessRegisteredEventArgs();
                        {
                            args->_Tag = regCmd->m_tag;
                            args->_Name = Convert::String::ToCLI( regCmd->m_name );
                        }
                        m_target->OnProcessRegistered( args );
                    }
                    else if( const ProcessUpdatedCmd* updatedCmd = cmd.asUpdatedCmd() )
                    {
                        ProcessUpdatedEventArgs^ args = clinew ProcessUpdatedEventArgs();
                        {
                            args->_Tag = updatedCmd->m_tag;
                        }
                        m_target->OnProcessUpdated( args );
                    }
                    else if ( const ProcessSelectionChangedCmd* selectionChangedCmd = cmd.asSelectionChangedCmd() )
                    {
                        ProcessSelectionChangedEventArgs^ args = clinew ProcessSelectionChangedEventArgs();
                        {
                            args->_Tag = selectionChangedCmd->m_tag;
                            args->_Selected = selectionChangedCmd->isSelected();
                        }
                        m_target->OnProcessSelectionChanged( args );
                    }
                    else
                    {
                        HK_VDB_SIGNAL_ERROR_MSG( 0xfdb00000, hkVdbError::CMD_UNKNOWN, "Signaler does not understand cmd type" );
                        result.signalError( *this );
                    }
                }
                catch ( CLI::Exception^ e )
                {
                    HK_VDB_SIGNAL_ERROR_MSG(
                        0xfdb00001,
                        hkVdbError::CMD_HANDLER_ERROR,
                        "Signaler encountered exception: " << hkUtf8::Utf8FromWide( e->Message ).cString() );

                    // Bubble up via signal result
                    result.signalError( *this );
                }
            }

        private:

            WeakCLIPtr<ProcessHandler^> m_target;
        };
    }
}

bool Process::Selected::get()
{
    
    hkBool32 isSelected;
    if ( m_processHandler.isProcessSelected( _Tag, isSelected ).isSuccess() )
    {
        return isSelected;
    }
    return false;
}

void Process::Selected::set( bool selected )
{
    
    m_processHandler.setProcessSelected( _Tag, selected );
}

Process^ ProcessHandler::GetProcess( int tag )
{
    if ( const char* processName = m_processHandler.getProcessName( tag ) )
    {
        Process^ process = clinew Process( m_processHandler );
        {
            process->_Tag = tag;
            process->_Name = Convert::String::ToCLI( processName );
        }
        return process;
    }
    return nullptr;
}

Process^ ProcessHandler::GetProcess( CLI::String^ name )
{
    int processTag = m_processHandler.getProcessTag( hkUtf8::Utf8FromWide( name ) );
    if ( processTag != -1 )
    {
        Process^ process = clinew Process( m_processHandler );
        {
            process->_Tag = processTag;
            process->_Name = name;
        }
        return process;
    }
    return nullptr;
}

ProcessHandler::ProcessHandler( hkVdbClient& client ) :
    m_processHandler( *client.getCmdHandler<hkVdbProcessHandler>() )
{
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->addReference(); )
    m_signaler = new ProcessHandlerSignaler( this );
    HK_SUBSCRIBE_TO_SIGNAL( m_processHandler.m_processCmdReceived, m_signaler, ProcessHandlerSignaler );
    m_processHandler.addReference();
}

HK_VDB_DEFINE_UMDTOR( ProcessHandler )
{
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->initGCThread(); )
    m_processHandler.m_processCmdReceived.unsubscribeAll( m_signaler );
    delete m_signaler;
    m_processHandler.removeReference();
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->removeReference(); )
}

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
