// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbClient;
class hkVdbPlaybackHandler;

namespace Havok
{
    namespace Vdb
    {
        ref class PlaybackHandler;
        ref class RenderSurface;

        public enum class PlaybackState
        {
            Playing,
            Paused
        };

        public enum class PlaybackDirection
        {
            Forward,
            Backward
        };

        [MetadataCLI::Flags]
        public enum class PlaybackFlags : unsigned int
        {
            
            Recording = ( 1 << 8 ),
            Replaying = ( 1 << 9 ),
            FastReplay = ( 1 << 10 ),
            Caching = ( 1 << 11 ),
            FrameEnded = ( 1 << 12 ),
            AvailableCommandsProcessed = ( 1 << 13 )
        };

        public ref struct PlaybackFrameRates sealed
        {
#ifdef HK_VDB_CLI_MANAGED
            literal double ServerFrameRate = 0.0;
            literal double TwentyFps = 20.0;
            literal double ThirtyFps = 30.0;
            literal double SixtyFps = 60.0;
            literal double FortyHertz = ( TwentyFps * 2 );
            literal double SixtyHertz = ( ThirtyFps * 2 );
            literal double OneTwentyHertz = ( SixtyFps * 2 );
            literal double FiftyMpf = ( 1 / TwentyFps * 1000 );
            literal double ThirtyMpf = ( 1 / ( 33.0 + ( 1 / 3.0 ) ) * 1000 );
            literal double FifteenMpf = ( 1 / ( 6e-5 + ( 2 / 3.0 ) ) * 1000 );
#else
            static property double ServerFrameRate { double get() { return 0.0; } }
            static property double TwentyFps { double get() { return 20.0; } }
            static property double ThirtyFps { double get() { return 30.0; } }
            static property double SixtyFps { double get() { return 60.0; } }
            static property double FortyHertz { double get() { return ( 20.0 * 2 ); } }
            static property double SixtyHertz { double get() { return ( 30.0 * 2 ); } }
            static property double OneTwentyHertz { double get() { return ( 60.0 * 2 ); } }
            static property double FiftyMpf { double get() { return ( 1 / 20.0 * 1000 ); } }
            static property double ThirtyMpf { double get() { return ( 1 / ( 33.0 + ( 1 / 3.0 ) ) * 1000 ); } }
            static property double FifteenMpf { double get() { return ( 1 / ( 6e-5 + ( 2 / 3.0 ) ) * 1000 ); } }
#endif
        };

        public ref struct PlaybackCmdReceivedArgs sealed
        {
        public:

            property PlaybackState PreviousState { PlaybackState get() { return _PreviousState; } }
            property PlaybackState TargetState { PlaybackState get() { return _TargetState; } }
            property PlaybackDirection PreviousDirection { PlaybackDirection get() { return _PreviousDirection; } }
            property PlaybackDirection TargetDirection { PlaybackDirection get() { return _TargetDirection; } }
            property PlaybackFlags PreviousFlags { PlaybackFlags get() { return _PreviousFlags; } }
            property PlaybackFlags TargetFlags { PlaybackFlags get() { return _TargetFlags; } }
            property hkInt64 PreviousFrame { hkInt64 get() { return _PreviousFrame; } }
            property hkInt64 TargetFrame { hkInt64 get() { return _TargetFrame; } }
            bool FlagWasSet( PlaybackFlags flag ) { return ( int( _PreviousFlags & flag ) == 0 ) && ( int( _TargetFlags & flag ) != 0 ); }
            bool FlagWasCleared( PlaybackFlags flag ) { return ( int( _PreviousFlags & flag ) != 0 ) && ( int( _TargetFlags & flag ) == 0 ); }
            bool FlagChanged( PlaybackFlags flag ) { return ( _PreviousFlags & flag ) != ( _TargetFlags & flag ); }

        internal:

            PlaybackState _PreviousState;
            PlaybackState _TargetState;
            PlaybackDirection _PreviousDirection;
            PlaybackDirection _TargetDirection;
            PlaybackFlags _PreviousFlags;
            PlaybackFlags _TargetFlags;
            hkInt64 _PreviousFrame;
            hkInt64 _TargetFrame;
            bool _FrameEnded;
        };

        public delegate void PlaybackCmdReceivedHandler( PlaybackHandler^ sender, PlaybackCmdReceivedArgs^ args );

        public ref class PlaybackHandler sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event PlaybackCmdReceivedHandler^ PlaybackCmdReceived;

        internal:

            void OnPlaybackCmdReceived( PlaybackCmdReceivedArgs^ args ) { PlaybackCmdReceived( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:

            property Havok::Vdb::PlaybackState PlaybackState
            {
                Havok::Vdb::PlaybackState get();
                void set( Havok::Vdb::PlaybackState state );
            }

            property Havok::Vdb::PlaybackDirection PlaybackDirection
            {
                Havok::Vdb::PlaybackDirection get();
                void set( Havok::Vdb::PlaybackDirection state );
            }

            property Havok::Vdb::PlaybackFlags PlaybackFlags
            {
                Havok::Vdb::PlaybackFlags get();
                
            }

            property double PlaybackFrameRate
            {
                double get();
                void set( double fps );
            }

            property hkInt64 CurrentFrame
            {
                hkInt64 get();
                void set( hkInt64 frame );
            }

            property hkInt64 LastCompletedFrame
            {
                hkInt64 get();
            }

            property hkInt64 MaxProcessedFrame
            {
                hkInt64 get();
            }

            property hkInt64 MinFrame
            {
                hkInt64 get();
            }

            property hkInt64 MaxFrame
            {
                hkInt64 get();
            }

            void PlayTo( hkInt64 frame );
            void AdvanceOne();
            void AdvanceOne( Havok::Vdb::PlaybackDirection direction );
            
            //void SaveReplay( StreamCLI^ stream );
            //void SaveReplay( StreamCLI^ stream, hkUint32 startFrame );
            //void SaveReplay( StreamCLI^ stream, hkUint32 startFrame, hkUint32 endFrame );
            //void StartRecording( StreamCLI^ stream );
            void SaveReplay( CLI::String^ filePath );
            void SaveReplay( CLI::String^ filePath, hkUint32 startFrame );
            void SaveReplay( CLI::String^ filePath, hkUint32 startFrame, hkUint32 endFrame );
            void StartRecording( CLI::String^ filePath );
            void SaveDebugReplay( CLI::String^ filePath );
            void SaveDebugReplay( CLI::String^ filePath, hkUint32 startFrame );
            void SaveDebugReplay( CLI::String^ filePath, hkUint32 startFrame, hkUint32 endFrame );
            void StartDebugRecording( CLI::String^ filePath );
            void StopRecording();
            void SyncToConnection();
            void SuspendExpensiveFrameUpdates();
            void ResumeNormalFrameUpdates();

            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            PlaybackHandler( hkVdbClient& client, RenderSurface^ surface );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( PlaybackHandler );
            HK_VDB_DECLARE_UMDTOR( PlaybackHandler );

        private:

            class PlaybackHandlerSignaler* m_signaler;

            hkVdbClient& m_client;
            RenderSurface^ m_surface;
            hkVdbPlaybackHandler& m_playbackHandler;
            bool m_expensiveFrameUpdateSuspended;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
