// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>

class hkVdbClient;
class hkVdbObjectHandler;
class hkVdbPlaybackHandler;

#if defined(HK_VDB_CLI_MANAGED)


using namespace System::ComponentModel;
namespace Havok
{
    namespace Vdb
    {
        [MetadataCLI::Flags]
        public enum class ObjectFlags : unsigned int
        {
            None = 0,
            Visible = ( 1 << 0 ),
            Queryable = ( 1 << 1 ),
            Transient = ( 1 << 2 ),
            RootObjectContainer = ( 1 << 3 ),
            Default = ( Visible | Queryable ),

            // Indicates the object is an update object, the previous flags aren't available in this context.
            // The previous property flags must be stored when the object is first added if they are of interest.
            Update = ( 1 << 28 ),

            // Extra flags which are inferred from object type, etc. (not sent by server)
            Displayable = ( 1 << 29 ),
        };

        [MetadataCLI::Flags]
        public enum class ConnectivityFlags : unsigned int
        {
            IncomingConnections = ( 1 << 0 ),
            OutgoingConnections = ( 1 << 1 ),
            All = ( IncomingConnections | OutgoingConnections )
        };

#if defined(HK_VDB_CLI_MANAGED)

        public interface struct VdbObject : public Havok::Vdb::Object
        {
            property hkUint64 Id { hkUint64 get(); }
            property ObjectFlags Flags { ObjectFlags get(); }
        };

#else
#error Need to move above constructs into the cli.h as #defines and fix the CameraController stuff in RenderSurface to use for managed, then can do UWP version properly
#endif
    }
}
#endif

namespace Havok
{
    namespace Vdb
    {
        ref class ObjectHandler;

        public interface class ObjectsChangedEvent { /* marking interface */ };
        public ref class ObjectsChangedEventArgs
        {
        public:
            ObjectsChangedEventArgs() { _ObjectsChangedEvents = clinew ListCLIImpl<ObjectsChangedEvent^>(); }
            property ListCLI<ObjectsChangedEvent^>^ ObjectsChangedEvents { ListCLI<ObjectsChangedEvent^>^ get() { return _ObjectsChangedEvents; } }
        internal:
            ListCLI<ObjectsChangedEvent^>^ _ObjectsChangedEvents;
        };

        public delegate void ObjectsChangedEventHandler( ObjectHandler^ sender, ObjectsChangedEventArgs^ args );

        public interface class ObjectsEvent : public ObjectsChangedEvent
        {
        public:
            property ListCLI<hkUint64>^ Ids { ListCLI<hkUint64>^ get(); }
        };

        public ref class ObjectsAddedEvent sealed : public ObjectsChangedEvent
        {
        public:
            property ListCLI<hkUint64>^ Ids { virtual ListCLI<hkUint64>^ get() { return _Ids; } }
            property ListCLI<Havok::Vdb::VdbObject^>^ Objects { ListCLI<Havok::Vdb::VdbObject^>^ get() { return _Objects; } }
            property int Tag { virtual int get() { return _Tag; } }
        internal:
            ListCLI<hkUint64>^ _Ids;
            ListCLI<Havok::Vdb::VdbObject^>^ _Objects;
            int _Tag;
        };

        public ref class ObjectsUpdatedEvent sealed : public ObjectsChangedEvent
        {
        public:
            property ListCLI<hkUint64>^ Ids { virtual ListCLI<hkUint64>^ get() { return _Ids; } }
            property ListCLI<Havok::Vdb::VdbObject^>^ Objects { ListCLI<Havok::Vdb::VdbObject^>^ get() { return _Objects; } }
        internal:
            ListCLI<hkUint64>^ _Ids;
            ListCLI<Havok::Vdb::VdbObject^>^ _Objects;
        };

        public ref class ObjectsRemovedEvent sealed : public ObjectsChangedEvent
        {
        public:
            property ListCLI<hkUint64>^ Ids { virtual ListCLI<hkUint64>^ get() { return _Ids; } }
        internal:
            ListCLI<hkUint64>^ _Ids;
        };

        public ref class ObjectConnectivityEvent : public ObjectsChangedEvent
        {
        public:
            property hkUint64 FromId { virtual hkUint64 get() { return _FromId; } }
            property ListCLI<hkUint64>^ ToIds { virtual ListCLI<hkUint64>^ get() { return _ToIds; } }
        internal:
            hkUint64 _FromId;
            ListCLI<hkUint64>^ _ToIds;
        };

        public ref class ObjectConnectedEvent sealed : public ObjectConnectivityEvent
        {
        public:
            property int Tag { virtual int get() { return _Tag; } }
        internal:
            int _Tag;
        };

        public ref class ObjectDisconnectedEvent sealed : public ObjectConnectivityEvent {};

        public ref class ObjectSetConnectivityEvent sealed : public ObjectConnectivityEvent {};

        public ref class ObjectHandler sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            
            event ObjectsChangedEventHandler^ ObjectsChanged;

        internal:

            void OnObjectsChanged( ObjectsChangedEventArgs^ args ) { ObjectsChanged( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:

#ifdef HK_DEBUG
            property int DisposedObjectEntryCount { int get(); }
            property int DisposedObjectCount { int get(); }
#endif

            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            ObjectHandler( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( ObjectHandler );
            HK_VDB_DECLARE_UMDTOR( ObjectHandler );

        private:

            class ObjectHandlerSignaler* m_signaler;

            hkVdbClient& m_client;
            hkVdbObjectHandler& m_objectHandler;
            hkVdbPlaybackHandler& m_playbackHandler;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
