// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbClient;
class hkVdbFileHandler;

namespace Havok
{
    namespace Vdb
    {
        ref class FileHandler;

        public ref struct FileCmdReceivedArgs sealed
        {
        public:

            property int Tag { int get() { return _Tag; } }
            property CLI::String^ TypeName { CLI::String^ get() { return _TypeName; } }
            property ListCLI<CLI::String^>^ Extensions { ListCLI<CLI::String^>^ get() { return _Extensions; } }
            property StreamCLI^ MemoryStream { StreamCLI^ get() { return _MemoryStream; } }

        internal:

            int _Tag;
            CLI::String^ _TypeName;
            ListCLI<CLI::String^>^ _Extensions;
            StreamCLI^ _MemoryStream;
        };

        public delegate void FileCmdReceivedHandler( FileHandler^ sender, FileCmdReceivedArgs^ args );

        public ref class FileHandler sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event FileCmdReceivedHandler^ FileCmdReceived;

        internal:

            void OnFileCmdReceived( FileCmdReceivedArgs^ args ) { FileCmdReceived( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:
            

            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            FileHandler( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( FileHandler );
            HK_VDB_DECLARE_UMDTOR( FileHandler );

        private:

            class FileHandlerSignaler* m_signaler;

            hkVdbFileHandler& m_fileHandler;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
