// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once






class hkVdbClient;
class hkVdbDisplayHandler;

#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>

namespace Havok
{
    namespace Vdb
    {
        ref class RenderSurface;
        ref class DisplayHandler;

        public enum class GeometryEvent : int
        {
            Added,
            Updated,
            Removed
        };
        public ref struct GeometryCmdReceivedArgs
        {
            GeometryCmdReceivedArgs(hkUint64 id, GeometryEvent evt) { Id = id; Event = evt;}
            hkUint64 Id;
            GeometryEvent Event;
        };
        public delegate void GeometryCmdReceivedHandler( DisplayHandler^ sender, GeometryCmdReceivedArgs^ args );

        public interface struct DisplayOptions
        {
                property Vector Up;
                property float UnitSize;
                property Aabb DisplayBounds;
        };
        public interface struct DisplayOptionsSetEventArgs : DisplayOptions {};
        public delegate void DisplayOptionsSetEventHandler( DisplayHandler^ sender, DisplayOptionsSetEventArgs^ args );

        public ref struct CameraEventArgs sealed
        {
            public:
                property CLI::String^ Name { CLI::String^ get() { return _Name; } }
            internal:
                CLI::String^ _Name;
        };
        public delegate void CameraEventHandler( DisplayHandler^ sender, CameraEventArgs^ args );

        public ref class DisplayHandler sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event GeometryCmdReceivedHandler^ GeometryCmdReceived;
            event DisplayOptionsSetEventHandler^ DisplayOptionsSet;
            event CameraEventHandler^ CameraAdded;
            event CameraEventHandler^ CameraRemoved;

        internal:

            void OnGeometryCmdReceived( GeometryCmdReceivedArgs^ args ) { GeometryCmdReceived( this, args ); }
            void OnDisplayOptionsSet( DisplayOptionsSetEventArgs^ args ) { DisplayOptionsSet( this, args ); }
            void OnCameraAdded( CameraEventArgs^ args ) { CameraAdded( this, args ); }
            void OnCameraRemoved( CameraEventArgs^ args ) { CameraRemoved( this, args ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:

            property DisplayOptions^ DisplayOptions
            {
                Havok::Vdb::DisplayOptions^ get();
                void set( Havok::Vdb::DisplayOptions^ options );
            }

            //////////////////////////////////////////////////////////////////////////
            // Internal Class Impl
            //////////////////////////////////////////////////////////////////////////

        internal:

            DisplayHandler( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_PASSTHROUGH_MDTOR( DisplayHandler );
            HK_VDB_DECLARE_UMDTOR( DisplayHandler );

        private:

            class DisplayHandlerSignaler* m_signaler;

            hkVdbClient& m_client;
            hkVdbDisplayHandler& m_displayHandler;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
