// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/Handlers/CustomHandler.h>

HK_VDB_MCLI_PP_PUSH_MANAGED( off )



#include HK_VDB_MCLI_INCLUDE( VisualDebugger/VdbServicesCLI/System/BaseSystem.h )

#include <Common/Base/Container/LocalArray/hkLocalArray.h>
#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/Serialize/hkVdbIStream.h>

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/hkVdbClient.h>
#include <VisualDebugger/VdbServices/System/Command/Handlers/hkVdbCustomHandler.h>

#define DEBUG_LOG_IDENTIFIER "vdb.CustomHandler"
#include <Common/Base/System/Log/hkLog.hxx>

HK_VDB_MCLI_PP_SWITCH_MANAGED()

#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>

using namespace Havok::Vdb;
typedef hkVdbCustomHandler::CmdInfo CmdInfo;

namespace Havok
{
    namespace Vdb
    {
        
        class CustomHandlerSignaler : public hkVdbDefaultErrorReporter
        {
        public:

            CustomHandlerSignaler( CustomHandler^ target ) :
                hkVdbDefaultErrorReporter( &s_debugLog ),
                m_target( target )
            {}

            void CustomHandlerSignaler::onCustomCmdReceivedSignal( const CmdInfo& cmdInfo, hkVdbSignalResult& result )
            {
                try
                {
                    CustomCmdReceivedArgs^ args = clinew CustomCmdReceivedArgs();
                    {
                        args->_Protocol = cmdInfo.m_protocol;
                        args->_CustomType = hkUint16( cmdInfo.m_customType );
                        args->_MemoryStream = Convert::Stream::Reader::ToCLI( const_cast< hkInt8* >( cmdInfo.m_data.begin() ), cmdInfo.m_data.getSize() );
                    }
                    m_target->OnCustomCmdReceived( args );
                }
                catch ( CLI::Exception^ e )
                {
                    HK_VDB_SIGNAL_ERROR_MSG(
                        0xfdb00010,
                        hkVdbError::CMD_HANDLER_ERROR,
                        "Signaler encountered exception: " << hkUtf8::Utf8FromWide( e->Message ).cString() );

                    // Bubble up via signal result
                    result.signalError( *this );
                }
            }

        private:

            WeakCLIPtr<CustomHandler^> m_target;
        };
    }
}

CustomHandler::CustomHandler( hkVdbClient& client ) :
    m_customHandler( *client.getCmdHandler<hkVdbCustomHandler>() )
{
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->addReference(); )
    m_signaler = new CustomHandlerSignaler( this );
    HK_SUBSCRIBE_TO_SIGNAL( m_customHandler.m_customCmdReceived, m_signaler, CustomHandlerSignaler );
    m_customHandler.addReference();
}

HK_VDB_DEFINE_UMDTOR( CustomHandler )
{
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->initGCThread(); )
    m_customHandler.m_customCmdReceived.unsubscribeAll( m_signaler );
    delete m_signaler;
    m_customHandler.removeReference();
    HK_VDB_IF_MANAGED( BaseSystem::getInstance()->removeReference(); )
}

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
