// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Visualize/hkVisualDebugger.h>

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/Error.h>

HK_VDB_MCLI_PP_PUSH_MANAGED( off )

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/hkVdbDefaultError.h>

HK_VDB_MCLI_PP_SWITCH_MANAGED()

using namespace Havok::Vdb;

void Error::SetIsEnabled( hkUint32 id, bool enabled )
{
    if ( hkVdbDefaultErrorFilter* filter = hkVdbDefaultErrorFilter::getInstancePtr() )
    {
        filter->setIsEnabled( id, enabled );
    }
}

bool Error::IsEnabled( hkUint32 id )
{
    if ( hkVdbDefaultErrorFilter* filter = hkVdbDefaultErrorFilter::getInstancePtr() )
    {
        return filter->isEnabled( id );
    }
    return true;
}

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
