// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/BaseSystem.h>

// Keycode
#include <Common/Base/keycode.cxx>

// Exclude unused features
#include <Common/Base/Config/hkProductFeaturesNoPatchesOrCompat.h>
#undef HK_FEATURE_PRODUCT_PHYSICS_2012
#undef HK_FEATURE_PRODUCT_PHYSICS
#undef HK_FEATURE_PRODUCT_ANIMATION
#undef HK_FEATURE_PRODUCT_BEHAVIOR
#undef HK_FEATURE_PRODUCT_CLOTH
#undef HK_FEATURE_PRODUCT_DESTRUCTION_2012
#undef HK_FEATURE_PRODUCT_DESTRUCTION
#undef HK_FEATURE_PRODUCT_AI
#undef HK_FEATURE_PRODUCT_SCRIPT
#undef HK_FEATURE_PRODUCT_FX
#undef HK_FEATURE_PRODUCT_NEW_TOOLS
#undef HK_FEATURE_PRODUCT_ENGINE

#define HK_EXCLUDE_FEATURE_RegisterReflectedClasses
#define HK_EXCLUDE_LIBRARY_hkSceneData
#include <Common/Base/Config/hkProductFeatures.cxx>

HK_VDB_IF_NATIVE( using namespace Microsoft::WRL; )

static BaseSystem* s_basesystem = HK_NULL;

HK_VDB_IF_UNMANAGED( BOOL APIENTRY DllMain( HMODULE hModlue, DWORD dwReason, LPVOID lpReserved ) )
HK_VDB_IF_NATIVE( extern "C" BOOL WINAPI DllMain( _In_opt_ HINSTANCE hInstance, DWORD dwReason, _In_opt_ LPVOID lpReserved ) )


{
    if( dwReason == DLL_PROCESS_ATTACH )
    {
        s_basesystem = new BaseSystem();

        
        
        
        
        
        
        
        HK_VDB_IF_NATIVE( Module<InProcDisableCaching>::GetModule().Create(); )

        if ( !s_basesystem->initialize() )
        {
            
            
            
            return FALSE;
        }
    }
    else if( dwReason == DLL_PROCESS_DETACH )
    {
        
        HK_VDB_IF_NATIVE( Module<InProcDisableCaching>::GetModule().Terminate(); )

        delete s_basesystem;
        s_basesystem = HK_NULL;
    }

    return TRUE;
}

#if defined(HK_VDB_CLI_UNMANAGED)







#if 0

extern "C" HRESULT WINAPI DllCanUnloadNow()
{
    return ( !s_basesystem || !s_basesystem->getReferenceCount() ) ? S_OK : S_FALSE;
}

#endif

#endif

#if defined(HK_VDB_CLI_NATIVE)

extern "C" HRESULT WINAPI DllCanUnloadNow()
{
    const auto &module = Module<InProcDisableCaching>::GetModule();
    return module.GetObjectCount() == 0 ? S_OK : S_FALSE;
}

#if !defined(__WRL_CLASSIC_COM__)
extern "C" HRESULT WINAPI DllGetActivationFactory( _In_ HSTRING activatibleClassId, _Deref_out_ IActivationFactory** factory )
{
    auto &module = Module<InProcDisableCaching>::GetModule();
    return module.GetActivationFactory(activatibleClassId, factory);
}
#endif

#if !defined(__WRL_WINRT_STRICT__)
extern "C" HRESULT WINAPI DllGetClassObject( REFCLSID rclsid, REFIID riid, _Deref_out_ LPVOID *ppv )
{
    auto &module = Module<InProcDisableCaching>::GetModule();
    return module.GetClassObject(rclsid, riid, ppv);
}
#endif

#if defined(_M_IX86)
#   if !defined(__WRL_CLASSIC_COM__)
#       pragma comment(linker, "/EXPORT:DllGetActivationFactory=_DllGetActivationFactory@8,PRIVATE")
#   endif
#   if !defined(__WRL_WINRT_STRICT__)
#       pragma comment(linker, "/EXPORT:DllGetClassObject=_DllGetClassObject@12,PRIVATE")
#   endif
#   pragma comment(linker, "/EXPORT:DllCanUnloadNow=_DllCanUnloadNow@0,PRIVATE")
#elif defined(_M_ARM) || defined(_M_AMD64)
#   if !defined(__WRL_CLASSIC_COM__)
#       pragma comment(linker, "/EXPORT:DllGetActivationFactory,PRIVATE")
#   endif
#   if !defined(__WRL_WINRT_STRICT__)
#       pragma comment(linker, "/EXPORT:DllGetClassObject,PRIVATE")
#   endif
#   pragma comment(linker, "/EXPORT:DllCanUnloadNow,PRIVATE")
#endif

#endif

HK_VDB_MCLI_PP_POP()

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
