// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Memory/Router/hkMemoryRouter.h>

class hkDefaultTaskQueue;

class BaseSystem
{
public:

    BaseSystem();
    ~BaseSystem();

    bool initialize();
    bool initThread( hkMemoryRouter& router, const char* name );
    HK_VDB_IF_UNMANAGED( void initGCThread(); )
    HK_VDB_IF_MANAGED( void initGCThread(); )
    bool quitThread( hkMemoryRouter& router );
    void addReference() { m_referenceCount++; }
    void removeReference() { m_referenceCount--; }
    int getReferenceCount() const { return m_referenceCount; }

    static BaseSystem* getInstance() { return s_instance; }

private:

    int m_referenceCount;
    hkMemoryRouter* m_memoryRouter;
    hkDefaultTaskQueue* m_taskQueue; 
    HK_VDB_IF_UNMANAGED( hkMemoryRouter m_gcMemoryRouter; )
    HK_VDB_IF_UNMANAGED( hkBool32 m_gcThreadInited; )

    static BaseSystem* s_instance;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
