// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServicesCLI/VdbServicesCLI.h>
#include <VisualDebugger/VdbServicesCLI/System/BaseSystem.h>
#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <Common/Base/Types/hkWeakPtr.h>

// Checking memory system is orders of magnitude slower
//#define USE_CHECKING_MEMORY_SYSTEM

#if defined(HK_VDB_CLI_UNMANAGED)

extern bool hkgSystemDx9SExPcInit();
extern bool hkgSystemDx11PcInit(const char*);
bool hkgSystemDx9And11PcInit()
{
    return hkgSystemDx9SExPcInit() && hkgSystemDx11PcInit(HK_NULL);
}
#define hkgSystemInit hkgSystemDx9And11PcInit

extern void hkgSystemDx11PcQuit();
extern void hkgSystemDx9SExPcQuit();
void hkgSystemDx9And11PcQuit()
{
    hkgSystemDx9SExPcQuit();
    hkgSystemDx11PcQuit();
}
#define hkgSystemQuit hkgSystemDx9And11PcQuit

#elif defined(HK_VDB_CLI_NATIVE)

extern bool hkgSystemMetroInit();
#define hkgSystemInit hkgSystemMetroInit
extern void hkgSystemMetroQuit();
#define hkgSystemQuit hkgSystemMetroQuit
#define HK_VDB_D3D_VERSION "DirectX 9"

#endif

BaseSystem* BaseSystem::s_instance = HK_NULL;

static void HK_CALL VdbErrorReportFunction( const char* msg, void* errorReportObject )
{
    
    
    OutputDebugStringW( hkUtf8::WideFromUtf8( msg ) );
}

BaseSystem::BaseSystem() :
    m_referenceCount( 0 ),
    m_memoryRouter( HK_NULL ),
    m_taskQueue( HK_NULL )
    HK_VDB_IF_UNMANAGED( , m_gcThreadInited( false ) )
{
    _MM_SET_FLUSH_ZERO_MODE( _MM_FLUSH_ZERO_ON );
}

bool BaseSystem::initialize()
{
    bool initialized = false;

#if defined(USE_CHECKING_MEMORY_SYSTEM)
    m_memoryRouter = hkMemoryInitUtil::initChecking( hkMallocAllocator::m_defaultMallocAllocator );
#else
#if defined(HK_DEBUG_SLOW)
    m_memoryRouter = hkMemoryInitUtil::initLeakDetect( hkMallocAllocator::m_defaultMallocAllocator );
#else
    m_memoryRouter = hkMemoryInitUtil::initVdbDefault( hkMallocAllocator::m_defaultMallocAllocator );
#endif
#endif

    if ( m_memoryRouter )
    {
        // Force these *used* types to get included in the static initialization.
        // Otherwise the type nodes don't get properly registered and we'll assert when they are later referenced.
        const hkReflect::Type* t;
        t = hkReflect::getType<hkVector4>();
        t = hkReflect::getType<hkRotation>();
        t = hkReflect::getType<hkTransform>();
        t;

        initialized = ( hkBaseSystem::init( m_memoryRouter, VdbErrorReportFunction ).isSuccess() );
        initialized &= hkgSystemInit();
    }

    if ( initialized )
    {
        // We don't use hkWeakPtrs, so don't allow the registry to hurt our perf.
        // see COM-4168.
        hkWeakPtrDetail::StatusRegistry::replaceInstance( HK_NULL );
        s_instance = this;

        // While debugging, assert/warning/error spew can slow down performance.
        // Region below is for disabling specific asserts if need be.
        {
            //hkError::getInstance().setEnabled( 0x1ff88f0e, false );
        }
    }

    return initialized;
}

bool BaseSystem::initThread( hkMemoryRouter& router, const char* name )
{
    if ( hkMemoryRouter::getInstancePtr() )
    {
        return false;
    }

    hkMemorySystem::getInstance().threadInit( router, name );
    if ( hkBaseSystem::initThread( &router ).isSuccess() )
    {
        _MM_SET_FLUSH_ZERO_MODE( _MM_FLUSH_ZERO_ON );
        return true;
    }
    else
    {
        hkMemorySystem::getInstance().threadQuit( router );
        return false;
    }
}

bool BaseSystem::quitThread( hkMemoryRouter& router )
{
    bool succeeded = ( hkBaseSystem::quitThread().isSuccess() );
    hkMemorySystem::getInstance().threadQuit( router );
    return succeeded;
}

#if defined(HK_VDB_CLI_UNMANAGED)
void BaseSystem::initGCThread()
{
    // Note if the gcMemoryRouter gets initialized.
    m_gcThreadInited = ( initThread( m_gcMemoryRouter, "GCThread" ) || m_gcThreadInited );
}
#endif

BaseSystem::~BaseSystem()
{
    if ( s_instance )
    {
        HK_ASSERT( 0x22441089, !m_referenceCount, "Cleaning up while we still have a reference" );

#if defined(HK_VDB_CLI_UNMANAGED)
        if ( m_gcThreadInited )
        {
            hkMemorySystem::getInstance().threadQuit( m_gcMemoryRouter );
            
            //hkBaseSystem::quitThread();
        }
#endif
        
        hkgSystemQuit();
        hkBaseSystem::quit();
        hkMemoryInitUtil::quit();
        s_instance = HK_NULL;
    }
    delete m_memoryRouter;
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
