// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbServicesCLI/Client.h>
#include <VisualDebugger/VdbServicesCLI/System/Utils/Convert.h>
#include <VisualDebugger/VdbServicesCLI/System/Handlers/ObjectHandler.h>

class hkVdbClient;
class hkgWindow;
class hkgDisplayWorld;
class hkgVdbPlugin;
class hkgVdbWidget;
class hkgVdbGeometryControl;





namespace Havok
{
    namespace Vdb
    {
        ref class RenderSurface;
        interface struct RenderObject;
        ref class StatsHandler;
        interface struct ITimerNode;
        interface struct DisplayOptionsSetEventArgs;

        public delegate void HasRenderObjectsChangedEventHandler( RenderSurface^ sender, bool hasRenderObjects );

        public ref class SelectionChangedEventArgs sealed
        {
        public:
            property MapCLI<hkUint64, RenderObject^>^ AddedToSelected { MapCLI<hkUint64, RenderObject^>^ get() { return _AddedToSelected; } }
            property MapCLI<hkUint64, RenderObject^>^ RemovedFromSelected { MapCLI<hkUint64, RenderObject^>^ get() { return _RemovedFromSelected; } }
            property MapCLI<hkUint64, RenderObject^>^ AddedToHighlighted { MapCLI<hkUint64, RenderObject^>^ get() { return _AddedToHighlighted; } }
            property MapCLI<hkUint64, RenderObject^>^ RemovedFromHighlighted { MapCLI<hkUint64, RenderObject^>^ get() { return _RemovedFromHighlighted; } }
            
            property MapCLI<hkUint64, RenderObject^>^ Selected { MapCLI<hkUint64, RenderObject^>^ get() { return _Selected; } }
            property MapCLI<hkUint64, RenderObject^>^ Highlighted { MapCLI<hkUint64, RenderObject^>^ get() { return _Highlighted; } }
        internal:
            MapCLI<hkUint64, RenderObject^>^ _AddedToSelected;
            MapCLI<hkUint64, RenderObject^>^ _RemovedFromSelected;
            MapCLI<hkUint64, RenderObject^>^ _AddedToHighlighted;
            MapCLI<hkUint64, RenderObject^>^ _RemovedFromHighlighted;
            MapCLI<hkUint64, RenderObject^>^ _Selected;
            MapCLI<hkUint64, RenderObject^>^ _Highlighted;
        };
        public delegate void SelectionChangedEventHandler( RenderSurface^ sender, SelectionChangedEventArgs^ args );

        [MetadataCLI::Flags]
        public enum class SelectionFlags : unsigned int
        {
            IgnoreUnhighlightedSelections = ( 1 << 0 ),
            
            ModifySelectionOnGrabbingGeometry = ( 1 << 2 ),
            ModifyLocalPoiOnGrabbingGeometry = ( 1 << 3 ),
            Default = ( IgnoreUnhighlightedSelections | ModifySelectionOnGrabbingGeometry | ModifyLocalPoiOnGrabbingGeometry )
        };

        [MetadataCLI::Flags]
        public enum class CameraFlags : unsigned int
        {
            LookAtPrimaryPointOfInterest = ( 1 << 0 ),
            LookAtPrimaryGeometryCenter = ( 1 << 1 ),
            KeepRelativeToPrimaryPointOfInterest = ( 1 << 2 ),
            KeepRelativeToPrimaryGeometryCenter = ( 1 << 3 ),
            Default = ( 0 )
        };

        [MetadataCLI::Flags]
        public enum class DrawFlags : unsigned int
        {
            DrawPointsOfInterest = ( 1 << 0 ),
            DrawHighlightedBox = ( 1 << 1 ),
            DrawSelectedBox = ( 1 << 2 ),
            VisualizeDisplaySelection = ( 1 << 3 ),
            Default = ( DrawPointsOfInterest | DrawHighlightedBox | DrawSelectedBox | VisualizeDisplaySelection )
        };

        [MetadataCLI::Flags]
        public enum class RenderFlags : unsigned int
        {
            RandomizedColors    = ( 1 << 0 ),
            Wireframe           = ( 1 << 1 ),
            BackfaceCulling     = ( 1 << 2 ),
            CullmodeCcw         = ( 1 << 3 ),
            OutlineFaces        = ( 1 << 4 ),
            VisualizeGeometrySelection = ( 1 << 5 ),
            HideAll             = ( 1 << 6 ),
            Default             = ( BackfaceCulling | CullmodeCcw | VisualizeGeometrySelection )
        };

        public enum class RenderObjectVisibility
        {
            NeverVisible,
            Hideable,
            AlwaysVisible
        };

        
        public enum class KeyNavigationDirection
        {
            StrafeLeft,
            StrafeRight,
            MoveForward,
            MoveBackward,
            MoveUp,
            MoveDown
        };

#if defined(HK_VDB_CLI_NATIVE)
        public enum class RenderTickMethod
        {
            FixedTimestep,
            VariableTimestep
        };
#endif

        public enum class FitCameraTarget
        {
            World,
            Selection,
        };

        
        public enum class FitCameraOperation
        {
            UnitCubeFromAndTo,
            DefaultFromAndTo,
            DefaultTo,
            PositiveX,
            NegativeX,
            PositiveY,
            NegativeY,
            PositiveZ,
            NegativeZ
        };

        public interface struct CameraController
        {
            property CLI::String^ Name { CLI::String^ get(); }
            property PropertyBagCLI^ Options { PropertyBagCLI^ get(); }
        };

        public interface struct RenderWidget
        {
            property CLI::String^ Name { CLI::String^ get(); }
            property PropertyBagCLI^ Options { PropertyBagCLI^ get(); }
            property bool Enabled;
            property bool Installed;
        };

        public interface struct RenderObject
        {
            property hkUint64 Id { hkUint64 get(); }
            property hkUint32 NumTriangles { hkUint32 get(); }
            property hkUint32 NumVertices { hkUint32 get(); }
            property ColorCLI UserColor;
            property ColorCLI ServerColor { ColorCLI get(); }
            property ColorCLI CurrentColor { ColorCLI get(); }
            property ColorCLI RandomizedColor;
            property bool EnableUserColor;
            property RenderObjectVisibility Visibility;
            property bool IsHighlighted;
            property bool IsSelected;
        };

        public ref class RenderSurface sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event HasRenderObjectsChangedEventHandler^ HasRenderObjectsChanged;
            event SelectionChangedEventHandler^ SelectionChanged;

        internal:

            void OnHasRenderObjectsChanged( bool hasRenderObjects ) { HasRenderObjectsChanged( this, hasRenderObjects ); }
            void OnSelectionChanged( SelectionChangedEventArgs^ args ) { SelectionChanged( this, args ); }

        public:

            
            
            

            property ColorCLI ClearColor
            {
                ColorCLI get() { return m_clearColor; }
                void set( ColorCLI clearColor );
            }

            
            property CLI::String^ RenderCamera
            {
                CLI::String^ get() { return m_renderCamera; }
                void set( CLI::String^ camera );
            }

            property bool LockToRenderCamera;

            property bool LockLightToCamera;

            property CameraController^ RenderCameraController
            {
                CameraController^ get() { return m_renderCameraController; }
                void set( CameraController^ controller );
            }

            
            property ReadOnlyListCLI<CameraController^>^ CameraControllers { ReadOnlyListCLI<CameraController^>^ get(); }

            property Havok::Vdb::SelectionFlags SelectionFlags
            {
                Havok::Vdb::SelectionFlags get();
                void set( Havok::Vdb::SelectionFlags flags );
            }

            property Havok::Vdb::CameraFlags CameraFlags
            {
                Havok::Vdb::CameraFlags get();
                void set( Havok::Vdb::CameraFlags flags );
            }

            property Havok::Vdb::DrawFlags DrawFlags
            {
                Havok::Vdb::DrawFlags get();
                void set( Havok::Vdb::DrawFlags flags );
            }

            property Havok::Vdb::RenderFlags RenderFlags
            {
                Havok::Vdb::RenderFlags get();
                void set( Havok::Vdb::RenderFlags flags );
            }

#if defined(HK_VDB_CLI_NATIVE)
            property Havok::Vdb::RenderTickMethod RenderTickMethod
            {
                Havok::Vdb::RenderTickMethod get();
                void set( Havok::Vdb::RenderTickMethod method );
            }
#endif

            void SetPointOfInterest( Havok::Vdb::Vector worldPos );
            void SetLocalPointOfInterest( Havok::Vdb::RenderObject^ renderObject, Havok::Vdb::Vector localPos );
            void ClearPointOfInterest();
            
            bool IsObjectGeometry( Havok::Vdb::VdbObject^ displayable );
            bool IsObjectGeometry( Havok::Vdb::RenderObject^ renderObject );
            bool IsObjectHighlighted( Havok::Vdb::VdbObject^ displayable );
            bool IsObjectHighlighted( Havok::Vdb::RenderObject^ renderObject );
            bool IsObjectSelected( Havok::Vdb::VdbObject^ displayable );
            bool IsObjectSelected( Havok::Vdb::RenderObject^ renderObject );
            void ClearHighlightedObjects( ListCLI<Havok::Vdb::VdbObject^>^ displayables );
            void ClearHighlightedObjects( ListCLI<Havok::Vdb::RenderObject^>^ renderObjects );
            void ClearHighlightedObjects() { ClearHighlightedObjects( (ListCLI<Havok::Vdb::VdbObject^>^) nullptr ); }
            int HighlightObjects( ListCLI<Havok::Vdb::VdbObject^>^ displayables );
            int HighlightObjects( ListCLI<Havok::Vdb::RenderObject^>^ renderObjects );
            bool HighlightObject( Havok::Vdb::VdbObject^ displayable );
            bool HighlightObject( Havok::Vdb::RenderObject^ renderObject );
            int SetHighlightedObjects( ListCLI<Havok::Vdb::VdbObject^>^ displayables ) { ClearHighlightedObjects(); return HighlightObjects( displayables ); }
            int SetHighlightedObjects( ListCLI<Havok::Vdb::RenderObject^>^ renderObjects ) { ClearHighlightedObjects(); return HighlightObjects( renderObjects ); }
            property int HighlightedObjectCount { int get(); }
            void ClearSelectedObjects( ListCLI<Havok::Vdb::VdbObject^>^ displayables );
            void ClearSelectedObjects( ListCLI<Havok::Vdb::RenderObject^>^ renderObjects );
            void ClearSelectedObjects() { ClearSelectedObjects( ( ListCLI<Havok::Vdb::VdbObject^>^ ) nullptr ); }
            bool SelectObject( Havok::Vdb::VdbObject^ displayable );
            bool SelectObject( Havok::Vdb::RenderObject^ renderObject );
            int SelectObjects( ListCLI<Havok::Vdb::VdbObject^>^ displayables );
            int SelectObjects( ListCLI<Havok::Vdb::RenderObject^>^ renderObject );
            int SetSelectedObjects( ListCLI<Havok::Vdb::VdbObject^>^ displayables ) { ClearSelectedObjects(); return SelectObjects( displayables ); }
            int SetSelectedObjects( ListCLI<Havok::Vdb::RenderObject^>^ renderObjects ) { ClearSelectedObjects(); return SelectObjects( renderObjects ); }
            void ClearHighlightedAndSelectedObjects( ListCLI<Havok::Vdb::VdbObject^>^ displayables );
            void ClearHighlightedAndSelectedObjects( ListCLI<Havok::Vdb::RenderObject^>^ renderObjects );
            void ClearHighlightedAndSelectedObjects() { ClearHighlightedAndSelectedObjects( ( ListCLI<Havok::Vdb::VdbObject^>^ ) nullptr ); }
            property int SelectedObjectCount { int get(); }

            void SaveObject( CLI::String^ filePath, Havok::Vdb::VdbObject^ displayable );
            void SaveObject( CLI::String^ filePath, Havok::Vdb::RenderObject^ renderObject );
            void SaveSelectedObjects( CLI::String^ filePath );
            void SaveHighlightedObjects( CLI::String^ filePath );
            void SaveAllObjects( CLI::String^ filePath );

            property ReadOnlyListCLI<RenderWidget^>^ Widgets { ReadOnlyListCLI<RenderWidget^>^ get(); }
            System::Tuple<Havok::Vdb::RenderObject^, Havok::Vdb::Vector, Havok::Vdb::Vector>^ HitTest( int x, int y );
            RenderObject^ GetObjectRenderObject( Havok::Vdb::VdbObject^ displayable );
            RenderObject^ GetRenderObject( hkUint64 id );

            void FitCameraToTarget( FitCameraTarget target, FitCameraOperation operation );
            void FitCameraToAabb( Havok::Vdb::Aabb aabb, FitCameraOperation operation );
            void ResetLighting();

            property double UpdateFrameMs { double get(); }
            property double DrawFrameMs { double get(); }
            property int RenderObjectCount { int get(); }
            property bool HasRenderObjects { bool get() { return RenderObjectCount > 0; } }

            

            void Initialize( RenderSurfaceCLI^ surface, bool enableMsaa );
            void StartRenderLoop();
            void StopRenderLoop();
            void SetMovementKey( KeyNavigationDirection direction, KeyCLI key );

        internal:

            RenderSurface( hkVdbClient& client );

        HK_VDB_IF_NATIVE( public: )

            HK_VDB_DECLARE_MDTOR( RenderSurface );
            HK_VDB_DECLARE_UMDTOR( RenderSurface );

        internal:

            void AcquireRenderLock();
            void ReleaseRenderLock();
            hkgVdbPlugin* GetHkgPlugin() { return m_plugin; }
            void OnDisplayOptionsSet( DisplayHandler^ sender, DisplayOptionsSetEventArgs^ args );
            void OnTimerNodeChanged( StatsHandler^ sender, ITimerNode^ args );

        private:

            void CheckDisplayableReflection();
            void ExtractDisplayableId(
                Havok::Vdb::VdbObject^ displayable,
                hkUint64& geometryIdOut,
                hkUint64& immediateIdOut );
            void ExtractDisplayableIds(
                ListCLI<Havok::Vdb::VdbObject^>^ displayables,
                ListCLI<hkUint64>^% geometryIdsOut,
                ListCLI<hkUint64>^% immediateIdsOut );
            hkgWindow* CreateHkgRenderSurface( RenderSurfaceCLI^ surface, bool enableMsaa );
            void CleanupHkgRenderSurface();
            void InitializeHkgDisplayWorld( hkgWindow& window, hkgDisplayWorld& world );

            void Render();

            class RenderSurfaceSignaler* m_signaler;

            bool m_rendering;
            bool m_hadRenderObjects;
            hkInt64 m_drawFrameTicks;
            HK_VDB_IF_NATIVE( class StepTimer* m_timer; )
            HK_VDB_IF_NATIVE( Windows::Foundation::IAsyncAction^ m_renderLoopWorker; )

            PointCLI m_capturedMousePosition;
            ColorCLI m_clearColor;
            CLI::String^ m_renderCamera;
            CameraController^ m_renderCameraController;
            ListCLI<CameraController^>^ m_cameraControllers;
            ListCLI<RenderWidget^>^ m_widgets;
            hkgVdbPlugin* m_plugin;
            hkVdbClient& m_client;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
