// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Graphics/Dx11/hkGraphicsDX11.h>
#include <Graphics/Dx11/Shared/Window/hkgWindowDX11.h>

namespace Microsoft { namespace Wpf { namespace Interop { namespace DirectX { ref class D3D11Image; } } } }
namespace Havok { namespace Vdb { ref class RenderSurface; } }

class hkgWindowWpf : public hkgWindowDX11Base
{
public:
    static const HKG_WINDOW_CREATE_FLAG DEFAULT_FLAGS = ( HKG_WINDOW_DEFAULT | HKG_WINDOW_MSAA );
    static const HKG_WINDOW_BUFFERS DEFAULT_BUFFERS = ( HKG_WINDOW_BUF_COLOR | HKG_WINDOW_BUF_DEPTH16 );

    hkgWindowWpf(
        Havok::Vdb::RenderSurface^ owner,
        RenderSurfaceCLI^ surface,
        CLI::Action^ renderAction,
        HKG_WINDOW_CREATE_FLAG flags = DEFAULT_FLAGS,
        HKG_WINDOW_BUFFERS buffers = DEFAULT_BUFFERS );
    ~hkgWindowWpf();

    hkBool32 isValid() const;
    HK_INLINE HKG_WINDOW_CREATE_FLAG getFlags() const { return m_windowFlags; }
    HK_INLINE HKG_WINDOW_BUFFERS getBuffers() const { return m_windowBuffers; }

    virtual bool initialize(
        HKG_WINDOW_CREATE_FLAG flags,
        HKG_WINDOW_BUFFERS buffers,
        int w,
        int h,
        const char* name,
        void* platformHandle = HK_NULL,
        void* platformParentHandle = HK_NULL ) HK_OVERRIDE;
    void startRenderLoop();
    void stopRenderLoop();
    virtual bool updateSize( unsigned int w, unsigned int h ) HK_OVERRIDE;
    virtual bool clearBuffers() HK_OVERRIDE;
    virtual bool swapBuffers() HK_OVERRIDE;
    virtual void finishScene() HK_OVERRIDE;
    virtual HKG_WINDOW_MSG_STATUS peekMessages( bool inViewportResize = false ) HK_OVERRIDE;
    virtual bool getCurrentRTisMultisampled() const HK_OVERRIDE { return m_msaa; }
    double getUpdateFrameMs();

private:

    void initShaderCollection();
    HRESULT createRenderTargets( void* pResource );

    bool updateSizeForDpiScale( double w, double h, double scale );

    void fwdRequestRender( CLI::Object^ sender, CLI::EventArgs^ e );
    void fwdRender( CLI::IntPtr pResource, bool isNewSurface );
    void fwdD3DInitialize( bool resetting );
    void fwdD3DCleanup( bool resetting );
    void fwdSizeChanged( CLI::Object^ sender, CLI::Windows::SizeChangedEventArgs^ e );

    void setInputEventsEnabled( bool enabled );
    void fwdKeyDown( CLI::Object^ sender, CLI::Windows::Input::KeyEventArgs^ e );
    void fwdKeyUp( CLI::Object^ sender, CLI::Windows::Input::KeyEventArgs^ e );
    void fwdMouseDown( CLI::Object^ sender, CLI::Windows::Input::MouseButtonEventArgs^ e );
    void fwdMouseUp( CLI::Object^ sender, CLI::Windows::Input::MouseButtonEventArgs^ e );
    void fwdMouseWheel( CLI::Object^ sender, CLI::Windows::Input::MouseWheelEventArgs^ e );

    void captureMouse( POINT& pIn );
    hkBool32 dragCapturedMouse( POINT& pInOut );
    hkBool32 hasCapturedMouse() const { return ( m_mouseDownMonitor != NULL ); }
    void releaseMouse();
    void updateInput();

    
    

    StrongCLIPtr<CLI::Action^> m_renderAction;
    StrongCLIPtr<CLI::Object^> m_requestRenderFwder;
    HKG_WINDOW_CREATE_FLAG m_windowFlags;
    HKG_WINDOW_BUFFERS m_windowBuffers;


    bool m_inputEnabled;
    hkReal m_inputsChangedAcc;
    StrongCLIPtr<CLI::Object^> m_keyDownFwder;
    StrongCLIPtr<CLI::Object^> m_keyUpFwder;
    StrongCLIPtr<CLI::Object^> m_mouseDownFwder;
    StrongCLIPtr<CLI::Object^> m_mouseUpFwder;
    StrongCLIPtr<CLI::Object^> m_mouseWheelFwder;

    StrongCLIPtr<CLI::Windows::Controls::Panel^> m_panel;
    StrongCLIPtr<Microsoft::Wpf::Interop::DirectX::D3D11Image^> m_image;
    StrongCLIPtr<System::TimeSpan^> m_lastRenderTime;

    StrongCLIPtr<Havok::Vdb::RenderSurface^> m_owner;

    HMONITOR m_mouseDownMonitor;
    HKG_MOUSE_BUTTON m_queuedMouseDownButtons;
    hkInt64 m_updateFrameTicks;
    ID3D11Query* m_query;

    ID3D11Texture2D* m_renderTargetBufferMsaa;
};

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
