// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkMemoryRouter;
class hkVdbClient;




namespace Havok
{
    namespace Vdb
    {
        ref class RenderSurface;
        ref class Client;
        ref class ProgressReporter;
        ref class CustomHandler;
        ref class FileHandler;
        ref class ObjectHandler;
        ref class PlaybackHandler;
        ref class ProcessHandler;
        ref class SetupHandler;
        ref class StatsHandler;
        ref class TextHandler;
        ref class DisplayHandler;

        public enum class ConnectedSource
        {
            None,
            File,
            Network,
            
        };

        public enum class ConnectedState
        {
            Disconnected,
            Connecting,
            Connected,
            Errored
        };

        public enum class StepState
        {
            NotStarted,
            Started,
            Completed,
        };

        public ref struct StepCompletedEventArgs sealed
        {
        public:
            property hkUint32 FrameNumber { hkUint32 get() { return _FrameNumber; } }
            property float StartTime { float get() { return _StartTime; } }
            property float Duration { float get() { return _Duration; } }

        internal:
            hkUint32 _FrameNumber;
            float _StartTime;
            float _Duration;
        };

        public delegate void StepCompletedHandler( Client^ sender, StepCompletedEventArgs^ args );
        public delegate void ConnectionHandler( Client^ sender );

        public ref struct ServerInfo sealed
        {
        public:
            property CLI::String^ Name { CLI::String^ get() { return _Name; } }
            property IpAddressCLI^ IpAddress { IpAddressCLI^ get() { return _IpAddress; } }
            property hkUint16 Port { hkUint16 get() { return _Port; } }
            virtual CLI::String^ ToString() override;

        internal:
            CLI::String^ _Name;
            IpAddressCLI^ _IpAddress;
            hkUint16 _Port;
        };

        public ref class Client sealed
        {
            //////////////////////////////////////////////////////////////////////////
            // Public Events
            //////////////////////////////////////////////////////////////////////////

        public:

            event StepCompletedHandler^ StepCompleted;
            event ConnectionHandler^ Connecting;
            event ConnectionHandler^ Connected;
            event ConnectionHandler^ Disconnecting;
            event ConnectionHandler^ Disconnected;
            event ConnectionHandler^ RecordingStarted;
            event ConnectionHandler^ RecordingStopped;
            event ConnectionHandler^ FileReadCompleted;
            event ConnectionHandler^ FileProcessingCompleted;

        internal:

            void OnStepCompleted( StepCompletedEventArgs^ args ) { StepCompleted( this, args ); }
            void OnConnecting() { Connecting( this ); }
            void OnConnected() { Connected( this ); }
            void OnDisconnecting() { Disconnecting( this ); }
            void OnDisconnected() { Disconnected( this ); }
            void OnRecordingStarted() { RecordingStarted( this ); }
            void OnRecordingStopped() { RecordingStopped( this ); }
            void OnFileReadCompleted() { FileReadCompleted( this ); }
            void OnFileProcessingCompleted() { FileProcessingCompleted( this ); }

            //////////////////////////////////////////////////////////////////////////
            // Public Methods
            //////////////////////////////////////////////////////////////////////////

        public:

            property Havok::Vdb::RenderSurface^ RenderSurface
            {
                Havok::Vdb::RenderSurface^ get() { return _RenderSurface; }
            }

            property Havok::Vdb::ProgressReporter^ ProgressReporter
            {
                Havok::Vdb::ProgressReporter^ get() { return _ProgressReporter; }
            }

            property Havok::Vdb::CustomHandler^ CustomHandler { Havok::Vdb::CustomHandler^ get() { return _CustomHandler; } }
            property Havok::Vdb::FileHandler^ FileHandler { Havok::Vdb::FileHandler^ get() { return _FileHandler; } }
            property Havok::Vdb::ObjectHandler^ ObjectHandler { Havok::Vdb::ObjectHandler^ get() { return _ObjectHandler; } }
            property Havok::Vdb::PlaybackHandler^ PlaybackHandler { Havok::Vdb::PlaybackHandler^ get() { return _PlaybackHandler; } }
            property Havok::Vdb::ProcessHandler^ ProcessHandler { Havok::Vdb::ProcessHandler^ get() { return _ProcessHandler; } }
            property Havok::Vdb::SetupHandler^ SetupHandler { Havok::Vdb::SetupHandler^ get() { return _SetupHandler; } }
            property Havok::Vdb::StatsHandler^ StatsHandler { Havok::Vdb::StatsHandler^ get() { return _StatsHandler; } }
            property Havok::Vdb::TextHandler^ TextHandler { Havok::Vdb::TextHandler^ get() { return _TextHandler; } }
            property Havok::Vdb::DisplayHandler^ DisplayHandler { Havok::Vdb::DisplayHandler^ get() { return _DisplayHandler; } }

            property Havok::Vdb::StepState StepState { Havok::Vdb::StepState get(); }
            property Havok::Vdb::ConnectedSource ConnectedSource { Havok::Vdb::ConnectedSource get(); }
            property Havok::Vdb::ConnectedState ConnectedState { Havok::Vdb::ConnectedState get(); }

            Havok::Vdb::StepState Process();
            Havok::Vdb::StepState Process( float processingTimeSec );

            bool ConnectToMachine();
            bool ConnectToMachine( CLI::String^ machineName );
            bool ConnectToMachine( CLI::String^ machineName, hkUint16 port );
            bool ConnectToMachine( CLI::String^ machineName, hkUint16 port, float timeoutMs );
            bool ConnectToFile( CLI::String^ filePath );
            
            void Disconnect();

            property bool IsServerDiscoveryEnabled { bool get(); }
            void EnableServerDiscovery( hkUint16 port );
            void EnableServerDiscovery( hkUint16 port, float timeoutMs );
            void DisableServerDiscovery();
            ReadOnlyListCLI<ServerInfo^>^ GetDiscoveredServers();
            void Poll();

            void InitBackgroundThread();
            void QuitBackgroundThread();

            //////////////////////////////////////////////////////////////////////////
            // Class
            //////////////////////////////////////////////////////////////////////////

        public:

            Client();
            HK_VDB_DECLARE_MDTOR( Client );
            HK_VDB_DECLARE_UMDTOR( Client );

        internal:

            hkVdbClient* getVdbClient() { return m_client; }

        public:

            static const hkUint16 CONNECT_DEFAULT_SERVER_PORT = 25001;
            static const hkUint16 ADVERTISE_DEFAULT_SERVER_PORT = 15001;

        private:

            
            
            
            
            

            Havok::Vdb::CustomHandler^ _CustomHandler;
            Havok::Vdb::FileHandler^ _FileHandler;
            Havok::Vdb::ObjectHandler^ _ObjectHandler;
            Havok::Vdb::PlaybackHandler^ _PlaybackHandler;
            Havok::Vdb::ProcessHandler^ _ProcessHandler;
            Havok::Vdb::SetupHandler^ _SetupHandler;
            Havok::Vdb::StatsHandler^ _StatsHandler;
            Havok::Vdb::TextHandler^ _TextHandler;
            Havok::Vdb::DisplayHandler^ _DisplayHandler;

            ref class RenderSurface^ _RenderSurface;
            ref class ProgressReporter^ _ProgressReporter;
            class ClientSignaler* m_signaler;

            hkMemoryRouter* m_backgroundThreadRouter;
            hkBool32 m_backgroundThreadInitialized;
            hkVdbClient* m_client;
        };
    }
}

/*
 * Havok SDK - Base file, BUILD(#20171210)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2017 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
