// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

//
// Precompiled header includes
//

#include <Common/Visualize/hkVisualize.h>
#include <Common/Visualize/hkVersionReporter.h>

#include <VisualDebugger/VdbServices/System/hkVdbTypes.h>
#include <VisualDebugger/VdbServices/System/hkVdbError.h>
#include <VisualDebugger/VdbServices/System/hkVdbDefaultError.h>

//
// Library defaults and constants
//

#define HK_VDB_DEFAULT_PORT 25001
#define HK_VDB_DEFAULT_MACHINE_NAME "localhost"
#define HK_VDB_DEFAULT_NETWORK_TIMEOUT_MS 1000
#define HK_VDB_DEFAULT_INPUT_BUFFER_DURATION_MS 10000.0f
#define HK_VDB_MIN_NETWORK_READ 16*1024 // in bytes, desired packet size




// This should not be set to more than an hkArray of bytes can hold.
#define HK_VDB_MAX_CMD_SIZE ( hkArray<hkInt8>::CAPACITY_MASK )
#define HK_VDB_AVG_FRAME_DURATION ( 1 / 30.0f )

#define HK_VDB_FPS_AVERAGING_WINDOW 100
#define HK_VDB_PROGRESS_TIME_EST_AVERAGING_WINDOW 20
#define HK_VDB_PROGRESS_TIME_EST_UPDATE_WEIGHTING 0.7f

#define HK_VDB_MAX_OUTPUT_BUFFER_SIZE ( 1024 )

//
// Helper funcs and macros
//


#define HK_PP_CLICKABLE_MESSAGE_PREAMBLE __FILE__ "(" HK_PP_STRINGIFY_VALUE(__LINE__) ") : "
#define HK_PP_WARNING(CODE, MSG) __pragma(message(HK_PP_CLICKABLE_MESSAGE_PREAMBLE "warning " CODE ": " MSG))
#define HK_PP_ERROR(CODE, MSG) __pragma(message(HK_PP_CLICKABLE_MESSAGE_PREAMBLE "error " CODE ": " MSG))

#include <Common/Base/Memory/System/Util/hkMemoryInitUtil.h>
namespace hkMemoryInitUtil
{
    /// Init the memory system with a good default for vdb services.
    HK_EXPORT_COMMON inline hkMemoryRouter* HK_CALL initVdbDefault(
        hkMemoryAllocator *memoryAllocator,
        const hkMemorySystem::FrameInfo& info = hkMemorySystem::FrameInfo() )
    {
        return initFreeList( memoryAllocator, HK_NULL, info );
    }
}

#if !defined(HK_VDB_BUILD)
#error this will not work, include hkBase.h first
#endif

#ifndef HK_EXPORT_VDB
#if defined(HK_DYNAMIC_DLL)
#   if defined(HK_DLL_BUILD) && (HK_DLL_BUILD==HK_VDB_BUILD) // DLL export for VDB
#       define HK_EXPORT_VDB __declspec(dllexport)
#       define HK_EXPORT_VDB_TEMPLATE_SPECIALIZATION
#   else // Being used in a non VDB dll build, but still a dll use, so import
#       define HK_EXPORT_VDB __declspec(dllimport)
#       define HK_EXPORT_VDB_TEMPLATE_SPECIALIZATION extern // see http://support.microsoft.com/kb/168958
#   endif
#else
#   define HK_EXPORT_VDB
#   define HK_EXPORT_VDB_TEMPLATE_SPECIALIZATION
#endif
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
