// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/Serialize/hkVdbIStream.h>
#include <Common/Visualize/Serialize/hkVdbOStream.h>

namespace hkVdbServices
{
    namespace Detail
    {
        /// A guaranteed unique address value.
        extern const void* const CONST_ADDR;
    }
}

class hkTaskQueue;

//////////////////////////////////////////////////////////////////////////
/// Info for processing data from an hkVdbClient.
//////////////////////////////////////////////////////////////////////////
struct hkVdbProcessInfo
{
    HK_DECLARE_CLASS( hkVdbProcessInfo, New );
    /// Use:
    ///  If processingTime <= 0, the vdb client will process until it doesn't read a cmd *or* it reaches the end of a frame
    ///  If processingTime > 0, the vdb client will process until it doesn't read a cmd *or* it reaches the elapsed time
    /// When connected to a network, it is not advised for processingTime > 0 because the server waits for a frame ack
    /// in order to step forward on the server-side.
    /// Note: hkTaskQueue is not currently used by the system, but may be in a future release.
    
    hkVdbProcessInfo( hkReal processingTimeSec = -1.0f, hkTaskQueue* queue = HK_NULL ) :
        m_processingTime( processingTimeSec ),
        m_taskQueue( queue )
    {}

    /// Get the task queue used for processing.
    /// Note: hkTaskQueue is not currently used by the system, but may be in a future release.
    hkTaskQueue* getTaskQueue() const { return m_taskQueue; }

    /// Returns true if we have more processing time.
    /// This is only relevant inside of the framework during an hkVdbClient::process(...) tick.
    hkBool32 hasMoreTime() const;

private:
    hkReal m_processingTime;
    hkTaskQueue* m_taskQueue;
    hkUint64 m_endTick;
    void computeEndTickCount();
    friend class hkVdbClient;
};

//////////////////////////////////////////////////////////////////////////
/// Generic storage class.
//////////////////////////////////////////////////////////////////////////


struct hkVdbStorage : public hkReferencedObject
{
    HK_DECLARE_CLASS( hkVdbStorage, New );
    hkArray<char> m_data;
};


















//#define HK_VDB_USE_HASH_MAP
#ifndef HK_VDB_USE_HASH_MAP
#include <Common/Base/Container/PointerMap/hkMap.h>
#include <Common/Base/Container/Set/hkSet.h>
#define hkVdbMap hkMap
#define hkVdbSet hkSet
#define HK_VDB_ON_HASH_MAP( x )
#define HK_VDB_ON_DEP_MAP( x ) x
#else
#include <Common/Base/Container/Hash/hkHashMap.h>
#include <Common/Base/Container/Hash/hkHashSet.h>
#define hkVdbMap hkHashMap
#define hkVdbSet hkHashSet
#define HK_VDB_ON_HASH_MAP( x ) x
#define HK_VDB_ON_DEP_MAP( x )
#endif

/// Appends the keys from the map to the provided array.
template <typename ArrayType, typename MapType>
void hkVdbMap_appendKeys( ArrayType& array, const MapType& map )
{
    array.reserve( array.getSize() + map.getSize() );
    for ( MapType::Iterator iter = map.getIterator();
        map.isValid( iter );
        iter = map.getNext( iter ) )
    {
        auto val = map.getKey( iter );
        array.pushBack( val );
    }
}

/// Appends the values from the map to the provided array.
template <typename ArrayType, typename MapType>
void hkVdbMap_appendValues( ArrayType& array, const MapType& map )
{
    array.reserve( array.getSize() + map.getSize() );
    for ( MapType::Iterator iter = map.getIterator();
        map.isValid( iter );
        iter = map.getNext( iter ) )
    {
        auto val = map.getValue( iter );
        array.pushBack( val );
    }
}














/// Copies src map to dst.
template <typename DstMapType, typename SrcMapType>
void hkVdbMap_copy( DstMapType& dst, const SrcMapType& src )
{
#ifndef HK_VDB_USE_HASH_MAP
    dst.reserve( dst.getSize() + src.getSize() );
    for ( SrcMapType::Iterator iter = src.getIterator();
        src.isValid( iter );
        iter = src.getNext( iter ) )
    {
        auto key = src.getKey( iter );
        auto val = src.getValue( iter );
        dst.insert( key, val );
    }
#else
    dst = src;
#endif
}


















//////////////////////////////////////////////////////////////////////////
/// Static functions used to create/check invalid objects for some types
//////////////////////////////////////////////////////////////////////////
template<typename T>
struct hkVdbValidity
{
    /// Create an invalid object of type T (if supported).
    static T invalid();

    /// Check if an object of type T is invalid (if supported).
    static hkBool32 isValid( const T& in );
};

template<typename U>
struct hkVdbValidity<hkArrayView<U>>
{
    static hkArrayView<U> invalid()
    {
        return hkArrayViewT::make<U>( (U*)( hkVdbServices::Detail::CONST_ADDR ), (U*)( hkVdbServices::Detail::CONST_ADDR ) );
    }
    static hkBool32 isValid( const hkArrayView<U>& in )
    {
        return ( hkUlong( in.begin() ) != hkUlong( hkVdbServices::Detail::CONST_ADDR ) );
    }
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
