// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

HK_INLINE hkVdbProgressWorkEstimate::hkVdbProgressWorkEstimate() :
    m_completedWorkItems( 0 ),
    m_estWorkItems( 0 ),
    m_estTimeRemaining( 0 )
{}

HK_INLINE void hkVdbProgressWorkEstimate::operator+=( const hkVdbProgressWorkEstimate& other )
{
    ( *this ) = ( *this + other );
}

HK_INLINE hkVdbProgressWorkEstimate hkVdbProgressWorkEstimate::operator+( const hkVdbProgressWorkEstimate& other ) const
{
    hkVdbProgressWorkEstimate estimate = *this;
    estimate.m_completedWorkItems += other.m_completedWorkItems;
    estimate.m_estWorkItems += other.m_estWorkItems;
    estimate.m_estTimeRemaining += other.m_estTimeRemaining;
    estimate.m_uninterruptible += other.m_uninterruptible;
    return estimate;
}

HK_INLINE void hkVdbProgressWorkEstimate::operator-=( const hkVdbProgressWorkEstimate& other )
{
    ( *this ) = ( *this - other );
}

HK_INLINE hkVdbProgressWorkEstimate hkVdbProgressWorkEstimate::operator-( const hkVdbProgressWorkEstimate& other ) const
{
    hkVdbProgressWorkEstimate estimate;
    estimate.m_completedWorkItems = hkUint32( hkMath::max2( hkInt64( m_completedWorkItems ) - other.m_completedWorkItems, 0 ) );
    estimate.m_estWorkItems = hkUint32( hkMath::max2( hkInt64( m_estWorkItems ) - other.m_estWorkItems, 0 ) );
    estimate.m_estTimeRemaining = ( m_estTimeRemaining - other.m_estTimeRemaining );
    estimate.m_uninterruptible = hkMath::max2( m_uninterruptible - other.m_uninterruptible, 0 );
    return estimate;
}

HK_INLINE hkVdbProgressWorkEstimate hkVdbProgressReporter::getTotalEstimate() const
{
    hkVdbProgressWorkEstimate totalEstimate;
    hkArray<hkUint64> ids;
    if ( getWorkLoads( ids ) )
    {
        totalEstimate = getEstimate( ids[0] );
        for ( int i = 1; i < ids.getSize(); i++ )
        {
            hkVdbProgressWorkEstimate estimate = getEstimate( ids[i] );
            totalEstimate += estimate;
        }
    }
    return totalEstimate;
}

HK_INLINE hkBool32 hkVdbProgressReporter::cancelAllWorkLoads()
{
    hkArray<hkUint64> ids;
    getWorkLoads( ids );
    hkBool32 cancelledWorkLoads = 0;
    for ( int i = 0; i < ids.getSize(); i++ )
    {
        cancelledWorkLoads += bool( cancelWorkLoad( ids[i] ) );
    }
    return cancelledWorkLoads;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
