// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/hkVdbDefaultError.h>

#include <Common/Base/System/Log/hkLog.h>
#include <Common/Base/Object/hkSingleton.h>

// Turn this on to enable breaking on errors
//#define BREAK_ON_ERROR

hkBool32 hkVdbDefaultErrorReporter::isFiltered() const
{
    bool notFiltered = true;
    if ( hkVdbDefaultErrorFilter* filter = hkVdbDefaultErrorFilter::getInstancePtr() )
    {
        notFiltered = notFiltered && ( ( m_error != hkVdbError::NONE ) && filter->isEnabled( m_error ) );
        notFiltered = notFiltered && ( ( m_errorId != 0 ) && filter->isEnabled( m_errorId ) );
    }
    return !notFiltered;
}

void hkVdbDefaultErrorReporter::reportError( hkLog::Origin* reportFrom ) const
{
    // First check for a sub-reporter
    if ( reporterHasError() )
    {
        m_reporter->reportError();
        return;
    }

    // See if we are filtered
    if ( isFiltered() )
    {
        return;
    }

    // Now see if we can output it
    hkLog::Origin* origin = ( reportFrom ) ? reportFrom : m_log;
    if ( origin )
    {
        _HK_VDB_EXTRA_REPORT_ERROR_FUNC( m_errorId, "[" << origin->getName() << "] " << hkVdbErrorStr[int( m_error )] << " : " << m_errorMsg );
        // Explicitly invoked to avoid addition of file/line loc, since it will always be the same.
        if ( origin->enabled( hkLog::Level::Error ) ) hkLog::Message( *origin, hkLog::Level::Error ).setText( HK_VARARGS1( "{0} : {1} (0x{2:X8})", hkVdbErrorStr[int( m_error )], m_errorMsg.cString(), m_errorId ) ).setId( m_errorId );
    }
    // Otherwise, custom report function is called
    else
    {
        _HK_VDB_EXTRA_REPORT_ERROR_FUNC( m_errorId, "" << hkVdbErrorStr[int( m_error )] << " : " << m_errorMsg );
        reportErrorCustom( m_errorId, m_error, m_errorMsg );
    }
}

void hkVdbDefaultErrorReporter::reportErrorCustom( hkUint32 id, hkVdbError::Enum error, const char* msg ) const
{
    HK_REPORT2( id, "" << hkVdbErrorStr[int( error )] << " : " << msg );
}

void hkVdbDefaultErrorReporter::errorSignalled() const
{
#ifdef BREAK_ON_ERROR
    if ( HK_VERY_UNLIKELY( !( ( getError() == hkVdbError::NONE ) || isFiltered() ) ) ) HK_BREAKPOINT( 0x22440957 );
#endif
}

HK_SINGLETON_IMPLEMENTATION( hkVdbDefaultErrorFilter );

#if 0

hkResult MyDefaultErrorReporter::myActionMethod( /*params*/ )
{
    HK_VDB_VERIFY_CONDITION_MSG(
        /*paramPtrToErrorReporter*/,
        0x2a431671,
        hkVdbError::INVALID_ARGUMENTS,
        "The paramPtrToErrorReporter cannot be null is not valid" );

    HK_VDB_VERIFY_CONDITION_MSG(
        /*paramValue > validValue*/,
        0x2a431672,
        hkVdbError::INVALID_ARGUMENTS,
        "The param value \"" << /*paramValue*/ << "\" is not valid" );

    // It's safe to call this pointer to an error reporter
    // because I would have already returned if it was null.
    // I'll call one of it's methods in a way that supports
    // the chaining of error reporting up the call tree.
    HK_VDB_VERIFY_REPORTER_OPERATION(
        /*paramPtrToErrorReporter*/ ->methodReturningHkResult(),
        * /*paramPtrToErrorReporter*/,
        // Fall-back error in case it doesn't behave
        hkVdbError::UNKNOWN_ERROR );

    // Do your action!!!

    // If we've made it here, we've succeeded
    return HK_SUCCESS;
}

#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
