// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

//////////////////////////////////////////////////////////////////////////
/// Flags describing the capabilities of the hkVdbClient.
/// This combines client-side capabilities with those of the currently
/// connected server.
//////////////////////////////////////////////////////////////////////////
struct HK_EXPORT_COMMON hkVdbCapabilities : public hkFlagsEx<hkUint32>
{
    enum Bits
    {
        NONE = 0,

        /// The capabilities are not completely known because we have
        /// not established any connection to a server yet.
        UNKNOWN = ( 1 << 0 ),

        /// The ability to save the contents of the cmd input buffer.
        SAVE_CMD_INPUT_BUFFER = ( 1 << 1 ),

        /// The ability for the system to start recording w/o disconnecting
        /// and reconnecting to the server (which can be expensive).
        QUICK_START_RECORDING = ( 1 << 2 ),
    };

    HK_DECLARE_FLAGS_EX_CLASS( hkVdbCapabilities, hkVdbCapabilities::Bits );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
