// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkVdbCmdInput;
struct hkVdbCmd;
class hkStreamWriter;

//////////////////////////////////////////////////////////////////////////
/// A debug hkStreamWriter which provides a cmd-at-a-time to a provided
/// func or writes the cmd to file in a human-readable form.
//////////////////////////////////////////////////////////////////////////
class hkVdbDebugWriter : public hkStreamWriter
{
public:
    HK_DECLARE_CLASS( hkVdbDebugWriter, New );
    typedef void( *hkCmdWriteFunc )( const hkVdbCmd& cmd, int protocol, void* handle );

    /// Creates a debug writer which will call func whenever a cmd is finished during writing.
    hkVdbDebugWriter( hkVdbCmdInput& input, hkCmdWriteFunc func, void* handle = HK_NULL );

    /// Creates a debug writer which will write human-readable forms of the cmds to file.
    hkVdbDebugWriter( hkVdbCmdInput& input, const char* filename );

    //
    // hkStreamWriter interface
    //

    HK_INLINE_VIRTUAL hkBool isOk() const HK_OVERRIDE { return m_currentCmdWriter.isOk(); }
    HK_INLINE_VIRTUAL void flush() HK_OVERRIDE { m_currentCmdWriter.flush(); }
    HK_INLINE_VIRTUAL hkBool seekTellSupported() const HK_OVERRIDE { return m_currentCmdWriter.seekTellSupported(); }
    HK_INLINE_VIRTUAL hkResult seek( int offset, SeekWhence whence ) HK_OVERRIDE { return m_currentCmdWriter.seek( offset, whence ); }
    HK_INLINE_VIRTUAL int tell() const HK_OVERRIDE { return m_currentCmdWriter.tell(); }
    HK_INLINE_VIRTUAL hkBool isBuffered() const HK_OVERRIDE { return m_currentCmdWriter.isBuffered(); }
    virtual int write( const void* buf, int nbytes ) HK_OVERRIDE;

    /// Write the provided cmd in a human-readable form to the writer.
    static void writeCmd( const hkVdbCmd& cmd, hkStreamWriter& writer, int protocol );

    /// Write a header based on the first cmd that is read.
    static void writeHeader( const hkVdbCmd& cmd, hkStreamWriter& writer, int protocol );

protected:

    HK_INLINE hkVdbCmd* currentCmd() { return reinterpret_cast< hkVdbCmd* >( m_currentCmdWriter.getData() ); }
    hkRefPtr<hkVdbCmdInput> m_input;
    hkBool m_writeHeader;
    int m_currentCmdBytesWritten;
    int m_currentCmdTotalBytes;
    hkArray<char> m_currentCmdStorage;
    hkArrayStreamWriter m_currentCmdWriter;
    hkRefPtr<hkStreamWriter> m_internalWriter;
    hkCmdWriteFunc m_writeFunc;
    void* m_writeFuncHandle;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
