// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/hkVisualDebuggerCmdType.h>

struct hkVdbCmd;
class hkStreamReader;

//////////////////////////////////////////////////////////////////////////
/// For advanced use only.
/// Utils for use with processing hkVdbCmds.
//////////////////////////////////////////////////////////////////////////
namespace hkVdbCmdUtils
{
    /// Returns true if the cmd is a persistent cmd
    /// (aka. to be stored in the hkVdbPersistentStateCache).
    hkBool32 isPersistentCmd( const hkVdbCmd& cmd );

    /// Extract the uids that are present in the cmd.
    hkResult extractUniqueIds(
        const hkVdbCmd& cmd,
        hkUint64& id,
        hkUint64& referenceId );

    /// Extract the uids that are present in the cmd.
    hkResult extractUniqueIds(
        const hkVdbCmd& cmd,
        hkUint64& id,
        hkUint64& referenceId,
        hkStreamReader& reader );

    /// Extract the uids that are present in the cmd.
    hkResult extractUniqueIds(
        hkVdbCmdType::Enum type,
        hkUint64& id,
        hkUint64& referenceId,
        hkStreamReader& reader );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
