// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Utils/hkVdbCmdUtils.h>

#include <Common/Visualize/hkVisualDebuggerCmdType.h>
#include <Common/Visualize/hkServerObjectHandler.h>

#include <VisualDebugger/VdbServices/System/Command/hkVdbCmd.h>

// You may need to update the below switches with any new persistent commands.
HK_COMPILE_TIME_ASSERT( hkVdbCmdType::MAX_SERVER_TO_CLIENT_CMD == 50 );

// If this value changes, you must update extractUniqueIdsInternal.  Additionally, old movies will not be able to be re-saved.
HK_COMPILE_TIME_ASSERT( hkVdbCustomCmdType::MAX_CUSTOM_CMD == ( 1 << sizeof( hkUint16 ) * 8 ) - 1 );

namespace hkVdbCmdUtils
{
    hkBool32 isPersistentCmd( const hkVdbCmd& cmd )
    {
        using namespace hkVdbCmdType;
        const hkVdbCmdType::Enum type = cmd.getType();
        switch ( type )
        {
            case SEND_SERVER_INFO:
            case CUSTOM_PERSIST:
            case CUSTOM_DEPENDENT:
            case SET_DISPLAY_OPTIONS:
            case SEND_STATS_MAPS:
            case ADD_GEOMETRY:
            case ADD_GEOMETRY_EX:
            case INSTANCE_GEOMETRY:
            case UPDATE_GEOMETRY:
            case UPDATE_GEOMETRY_TRANSFORM:
            case UPDATE_GEOMETRY_TRANSFORM_EX:
            case UPDATE_PARTICLE_TRANSFORMS:
            case UPDATE_GEOMETRY_VERTICES:
            case SET_GEOMETRY_COLOR:
            case SET_GEOMETRY_ALPHA:
            case SET_GEOMETRY_FLAG_BITS:
            case CLEAR_GEOMETRY_FLAG_BITS:
            case REMOVE_GEOMETRY:
            // Most Object Inspection Commands are handled by extracting data from the cache instead
            case REGISTER_OBJECT_TYPE:
            //case ADD_OBJECTS:
            //case UPDATE_OBJECTS:
            //case REMOVE_OBJECTS:
            //case CONNECT_OBJECTS:
            //case DISCONNECT_OBJECTS:
            case REGISTER_PROCESS:
            case REGISTER_PROCESS_EX:
            case UPDATE_PROCESS:
            case SELECT_PROCESS:
            case UNSELECT_PROCESS:
            case CLIENT_INTERNAL:
            // Deprecated
            case DEPRECATED_ADD_RIGID_GEOMETRY:
            case DEPRECATED_ADD_RIGID_GEOMETRY_EX:
            case DEPRECATED_ADD_MORPHING_GEOMETRY:
            case DEPRECATED_ADD_MORPHING_GEOMETRY_EX:
            case DEPRECATED_ADD_FIXED_GEOMETRY:
            case DEPRECATED_ADD_FIXED_GEOMETRY_EX:
            {
                return true;
            }
            default:
            {
                return false;
            }
        }
    }

    hkResult extractUniqueIdsInternal(
        hkVdbCmdType::Enum type,
        hkUint64& id,
        hkUint64& referenceId,
        hkVdbIStream& reader )
    {
        using namespace hkVdbCmdType;

        id = 0;
        referenceId = 0;

        if ( !reader.getStreamReader()->isOk() )
        {
            return HK_FAILURE;
        }

        switch ( type )
        {
            

            // Commands with 64-bit unique ids
            case CUSTOM_PERSIST:
            case CUSTOM_DEPENDENT:
            case ADD_GEOMETRY:
            case ADD_GEOMETRY_EX:
            case INSTANCE_GEOMETRY:
            case UPDATE_GEOMETRY:
            case UPDATE_GEOMETRY_TRANSFORM:
            case UPDATE_GEOMETRY_TRANSFORM_EX:
            case UPDATE_PARTICLE_TRANSFORMS:
            case UPDATE_GEOMETRY_VERTICES:
            case SET_GEOMETRY_COLOR:
            case SET_GEOMETRY_ALPHA:
            case SET_GEOMETRY_FLAG_BITS:
            case CLEAR_GEOMETRY_FLAG_BITS:
            case REMOVE_GEOMETRY:
                // Deprecated
            case DEPRECATED_ADD_RIGID_GEOMETRY:
            case DEPRECATED_ADD_RIGID_GEOMETRY_EX:
            case DEPRECATED_ADD_MORPHING_GEOMETRY:
            case DEPRECATED_ADD_MORPHING_GEOMETRY_EX:
            case DEPRECATED_ADD_FIXED_GEOMETRY:
            case DEPRECATED_ADD_FIXED_GEOMETRY_EX:
            {
                if ( ( type == CUSTOM_PERSIST ) || ( type == CUSTOM_DEPENDENT ) )
                {
                    // absorb custom cmd type value
                    reader.read16u();
                }
                id = reader.read64u();
                if ( ( type == INSTANCE_GEOMETRY ) || ( type == CUSTOM_DEPENDENT ) )
                {
                    referenceId = reader.read64u();
                }
                return HK_SUCCESS;
            }

            // Commands with 32-bit unique ids
            
            case REGISTER_OBJECT_TYPE:
            case REGISTER_PROCESS:
            case REGISTER_PROCESS_EX:
            case UPDATE_PROCESS:
            case SELECT_PROCESS:
            case UNSELECT_PROCESS:
            {
                id = reader.read32u();
                return HK_SUCCESS;
            }

            // Commands with 8-bit unique ids
            case CLIENT_INTERNAL:
            {
                id = reader.read8u();
                return HK_SUCCESS;
            }

            // Command with no ids
            default:
            {
                return HK_FAILURE;
            }
        }
    }

    hkResult extractUniqueIds(
        const hkVdbCmd& cmd,
        hkUint64& id,
        hkUint64& referenceId,
        hkStreamReader& reader )
    {
        hkVdbIStream stream( &reader );
        return extractUniqueIdsInternal( cmd.getType(), id, referenceId, stream );
    }

    hkResult extractUniqueIds(
        const hkVdbCmd& cmd,
        hkUint64& id,
        hkUint64& referenceId )
    {
        hkVdbLocalIStream stream( cmd.getData(), cmd.getDataSize() );
        return extractUniqueIdsInternal( cmd.getType(), id, referenceId, stream );
    }

    hkResult extractUniqueIds(
        hkVdbCmdType::Enum type,
        hkUint64& id,
        hkUint64& referenceId,
        hkStreamReader& reader )
    {
        hkVdbIStream stream( &reader );
        return extractUniqueIdsInternal( type, id, referenceId, stream );
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
