// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/Types/hkSignalSlots.h>

//////////////////////////////////////////////////////////////////////////
/// This class avoids the underlying hkStreamReader from reading if it's
/// at EOF so that it won't become invalid. Instead, it will simply inform
/// the caller that no data could be read.
/// If a single read crosses the EOF boundary, then this class does
/// not prevent it because this means we've got a corrupt read.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbBoundlessReader : public hkSeekableStreamReader
{
public:
    HK_DECLARE_CLASS( hkVdbBoundlessReader, New );
    hkVdbBoundlessReader( hkSeekableStreamReader& reader );

    //
    // hkSeakableStreamReader/hkStreamReader interface
    //

    virtual hkBool isOk() const HK_OVERRIDE { return m_reader->isOk() || (m_cur == m_readerEOF); }
    virtual int read( void* buf, int nbytes ) HK_OVERRIDE;
    virtual int skip( int nbytes ) HK_OVERRIDE;
    virtual int peek( void* buf, int n ) HK_OVERRIDE;
    virtual hkSeekableStreamReader* isSeekTellSupported() HK_OVERRIDE { return m_reader->isSeekTellSupported(); }
    virtual hkInplaceStreamReader* isInplace() HK_OVERRIDE { return m_reader->isInplace(); }
    virtual hkResult seek( int offset, SeekWhence whence ) HK_OVERRIDE { return m_reader->seek( offset, whence ); }
    virtual int tell() const HK_OVERRIDE { return m_reader->tell(); }

    //
    // Signals
    //

    HK_DECLARE_SIGNAL( EOFReachedSignal, hkSignal1<int> );
    /// Signals when the EOF is reached.
    EOFReachedSignal m_eofReached;

protected:

    hkRefPtr<hkSeekableStreamReader> m_reader;
    int m_cur;
    int m_readerEOF;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
