// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Utils/hkVdbBoundlessReader.h>





hkVdbBoundlessReader::hkVdbBoundlessReader( hkSeekableStreamReader& reader ) :
    m_reader( &reader ),
    m_cur( 0 )
{
    
    
    
    if ( reader.seek( 0, hkSeekableStreamReader::STREAM_END ).isSuccess() )
    {
        m_readerEOF = reader.tell();
        reader.seek( 0, hkSeekableStreamReader::STREAM_SET );
    }
    else
    {
        m_readerEOF = -1;
    }
}

int hkVdbBoundlessReader::read( void* buf, int nbytes )
{
    if ( HK_VERY_LIKELY( m_reader->isOk() ) )
    {
        const int bytes = m_reader->read( buf, nbytes );
        m_cur += bytes;
        if ( ( bytes > 0 ) && ( m_cur == m_readerEOF ) ) m_eofReached.fire( m_cur );
        return bytes;
    }
    else
    {
        return 0;
    }
}

int hkVdbBoundlessReader::skip( int nbytes )
{
    if ( HK_VERY_LIKELY( m_reader->isOk() ) )
    {
        const int bytes = m_reader->skip( nbytes );
        m_cur += bytes;
        if ( ( bytes > 0 ) && ( m_cur == m_readerEOF ) ) m_eofReached.fire( m_cur );
        return bytes;
    }
    else
    {
        return 0;
    }
}

int hkVdbBoundlessReader::peek( void* buf, int n )
{
    if ( HK_VERY_LIKELY( m_reader->isOk() ) )
    {
        return m_reader->peek( buf, n );
    }
    else
    {
        return 0;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
