// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

//////////////////////////////////////////////////////////////////////////
/// An hkStreamWriter which will ensure all bytes are written to
/// it's underlying stream. This is not a performant approach
/// and so is only used in very restricted ways.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbBlockingWriter : public hkStreamWriter
{
public:
    HK_DECLARE_CLASS( hkVdbBlockingWriter, New );
    hkVdbBlockingWriter( hkStreamWriter& writer ) : m_writer( &writer ) {}

    //
    // hkStreamWriter interface
    //

    virtual hkBool isOk() const HK_OVERRIDE { return m_writer->isOk(); }
    virtual int write( const void* buf, int nbytes ) HK_OVERRIDE;
    virtual void flush() { return m_writer->flush(); }
    virtual hkBool seekTellSupported() const { return m_writer->seekTellSupported(); }
    virtual hkResult seek( int offset, SeekWhence whence ) { return m_writer->seek( offset, whence ); }
    virtual int tell() const { return m_writer->tell(); }
    virtual hkBool isBuffered() const { return m_writer->isBuffered(); }

protected:

    hkRefPtr<hkStreamWriter> m_writer;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
