// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbServices/System/Connection/hkVdbConnection.h>

//////////////////////////////////////////////////////////////////////////
/// A connection which reads/writes cmds from/to a the provided streams.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbStreamConnection : public hkVdbConnection
{
public:
    HK_DECLARE_CLASS( hkVdbStreamConnection, New, ReflectIdentity );

    /// Create a connection which uses the provided streams to read-to/write-from.
    hkVdbStreamConnection( hkStreamReader* reader, hkStreamWriter* writer );

    // dtor
    ~hkVdbStreamConnection();

    //
    // hkVdbConnection interface.
    //

    virtual hkVdbConnectionState::Enum getState() const HK_OVERRIDE;
    virtual hkResult connect() HK_OVERRIDE;
    virtual hkResult disconnect() HK_OVERRIDE;
    virtual hkStreamReader* getReader() HK_OVERRIDE;
    virtual hkStreamWriter* getWriter() HK_OVERRIDE;

protected:

    hkStreamReader* m_reader;
    hkStreamWriter* m_writer;
    hkRefPtr<hkStreamReader> m_storedReader;
    hkRefPtr<hkStreamWriter> m_storedWriter;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
