// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Connection/hkVdbStreamConnection.h>

#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

#define DEBUG_LOG_IDENTIFIER "vdb.Connection.Stream"
#include <Common/Base/System/Log/hkLog.hxx>

hkVdbStreamConnection::hkVdbStreamConnection( hkStreamReader* reader, hkStreamWriter* writer ) :
    hkVdbConnection( &s_debugLog ),
    m_reader( HK_NULL ),
    m_writer( HK_NULL ),
    m_storedReader( reader ),
    m_storedWriter( writer )
{
    clearError();
}

hkVdbStreamConnection::~hkVdbStreamConnection()
{}

hkVdbConnectionState::Enum hkVdbStreamConnection::getState() const
{
    const char* errSource = "";
    hkBool32 readerOk = ( m_reader && m_reader->isOk() );
    hkBool32 writerOk = ( m_writer && m_writer->isOk() );
    if ( m_writer && !m_reader )
    {
        if ( writerOk )
        {
            return hkVdbConnectionState::CONNECTED;
        }
        errSource = "Writer";
    }
    else if ( !m_writer && m_reader )
    {
        if ( readerOk )
        {
            return hkVdbConnectionState::CONNECTED;
        }
        errSource = "Reader";
    }
    else if ( m_writer && m_reader )
    {
        if ( writerOk && readerOk )
        {
            return hkVdbConnectionState::CONNECTED;
        }
        errSource = "Either writer or reader";
    }
    else
    {
        return hkVdbConnectionState::DISCONNECTED;
    }

    HK_VDB_SIGNAL_ERROR_MSG(
        0xedb00084,
        hkVdbError::IO_ERROR,
        errSource << " is not valid" );

    return hkVdbConnectionState::ERRORED;
}

hkResult hkVdbStreamConnection::connect()
{
    m_reader = m_storedReader;
    m_writer = m_storedWriter;
    return HK_SUCCESS;
}

hkResult hkVdbStreamConnection::disconnect()
{
    m_reader = HK_NULL;
    m_writer = HK_NULL;
    return HK_SUCCESS;
}

hkStreamReader* hkVdbStreamConnection::getReader() { return m_reader; }
hkStreamWriter* hkVdbStreamConnection::getWriter() { return m_writer; }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
