// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

#include <Common/Base/System/Io/Socket/hkNetLobby.h>
#include <Common/Visualize/hkVisualDebugger.h>

#include <VisualDebugger/VdbServices/System/Connection/hkVdbConnection.h>

//////////////////////////////////////////////////////////////////////////
/// A connection which establishes information about servers awaiting connection.
//////////////////////////////////////////////////////////////////////////



class HK_EXPORT_VDB hkVdbServerDiscoveryConnection : public hkVdbConnection
{
public:
    HK_DECLARE_CLASS(hkVdbServerDiscoveryConnection, New, ReflectIdentity );

    /// Create a server discovery connection which broadcasts over the specified port.
    /// serverGroupId is used to determine servers of interest (see hkNetLobby).
    /// serverTimeoutMs is how long before a server is considered no longer active
    /// (aka, a server must be able to respond to requests at the specified timeout
    /// frequency or it will be removed from the discovered list).
    hkVdbServerDiscoveryConnection(
        hkUint16 broadcastPort = HK_VDB_ADVERTISE_SERVER_DEFAULT_PORT,
        int serverGroupId = HK_VDB_ADVERTISE_SERVER_DEFAULT_GROUP_ID,
        hkReal serverTimeoutMs = HK_VDB_DEFAULT_NETWORK_TIMEOUT_MS );

    //
    // hkVdbConnection interface.
    //

    virtual hkVdbConnectionState::Enum getState() const HK_OVERRIDE;
    virtual hkResult connect() HK_OVERRIDE;
    virtual hkResult disconnect() HK_OVERRIDE;
    virtual hkResult poll() HK_OVERRIDE;
    HK_INLINE_VIRTUAL virtual hkStreamReader* getReader() HK_OVERRIDE { return HK_NULL; }
    HK_INLINE_VIRTUAL virtual hkStreamWriter* getWriter() HK_OVERRIDE { return HK_NULL; }

    //
    // Query
    //

    /// Get the current list of discovered servers.
    const hkArray<hkNetLobby::SessionInfo>& getDiscoveredServers() const { return m_sortedConnectedSessions; }

protected:

    hkResult findSessions();
    void addNewResults();
    void cleanupStaleResults();

    hkUint16 m_broadcastPort;
    int m_serverGroupId;
    hkReal m_serverTimeoutMs;
    hkRefPtr<hkNetLobby> m_netLobby;
    int m_processedResults;
    hkArray<hkNetLobby::SessionInfo> m_sortedConnectedSessions;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
