// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <VisualDebugger/VdbServices/System/Connection/hkVdbConnection.h>

//////////////////////////////////////////////////////////////////////////
/// A connection which does nothing but won't error when read from or written to.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbNoOpConnection : public hkVdbConnection
{
public:
    HK_DECLARE_CLASS( hkVdbNoOpConnection, New, ReflectIdentity );

    /// Create a no-op connection.
    /// You can optionally provide a connection to read from and ack frames
    /// so that the wrapped connection keeps producing data (doesn't get stuck).
    hkVdbNoOpConnection( hkVdbConnection* connection = HK_NULL );

    /// Get the connection we are wrapping (if any).
    HK_INLINE hkVdbConnection* getWrappedConnection() const { return m_connection; }

    //
    // hkVdbConnection interface.
    //

    virtual hkVdbConnectionState::Enum getState() const HK_OVERRIDE;
    virtual hkResult connect() HK_OVERRIDE;
    virtual hkResult disconnect() HK_OVERRIDE;
    HK_INLINE_VIRTUAL hkStreamReader* getReader() HK_OVERRIDE { return m_reader; }
    HK_INLINE_VIRTUAL hkStreamWriter* getWriter() HK_OVERRIDE { return m_writer; }

protected:

    hkRefPtr<hkVdbConnection> m_connection;
    hkRefPtr<hkStreamReader> m_reader;
    hkRefPtr<hkStreamWriter> m_writer;
    hkVdbConnectionState::Enum m_state;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
