// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Connection/hkVdbNoOpConnection.h>

#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

#include <VisualDebugger/VdbServices/System/Command/hkVdbCmd.h>
#include <VisualDebugger/VdbServices/System/Connection/hkVdbNetworkConnection.h>

#define DEBUG_LOG_IDENTIFIER "vdb.Connection.NoOp"
#include <Common/Base/System/Log/hkLog.hxx>

namespace
{
    class NoOpReader : public hkSeekableStreamReader
    {
    public:
        HK_DECLARE_CLASS( NoOpReader, New )
        virtual hkBool isOk() const { return true; }
        virtual int read( void* buf, int nbytes ) { return 0; }
        virtual hkResult seek( int offset, SeekWhence whence ) { return HK_FAILURE; }
        virtual int tell() const { return 0; }
    };

    class NoOpWriter : public hkStreamWriter
    {
    public:
        HK_DECLARE_CLASS( NoOpWriter, New );
        virtual hkBool isOk() const { return true; }
        virtual int write( const void* buf, int nbytes ) { return nbytes; }
    };

    class NoOpAckReader : public NoOpReader
    {
    public:
        HK_DECLARE_CLASS( NoOpAckReader, New )
            NoOpAckReader( hkStreamReader* reader, hkStreamWriter* writer ) :
            m_reader( reader ),
            m_writer( writer ),
            m_currentCmdBytesRead( 0 ),
            m_currentCmdTotalBytes( HK_INT32_MAX )
        {}
        virtual hkBool isOk() const { return m_reader && !m_reader->isOk() ? false : NoOpReader::isOk(); }
        virtual int read( void* buf, int nbytes )
        {
            if ( m_reader )
            {
                hkVdbCmd* cmd;
                if ( m_currentCmdBytesRead == m_currentCmdTotalBytes )
                {
                    cmd = currentCmd();

                    // Reset to next command
                    m_currentCmdStorage.removeAtAndCopy( 0, cmd->getCmdSize() );
                    m_currentCmdBytesRead = ( m_currentCmdBytesRead - m_currentCmdTotalBytes );
                    m_currentCmdTotalBytes = ( m_currentCmdBytesRead >= 4 ) ? currentCmd()->getCmdSize() : HK_INT32_MAX;
                }

                int readSize = m_reader->read( buf, nbytes );

                m_currentCmdStorage.reserve( m_currentCmdBytesRead + readSize );
                hkString::memCpy( m_currentCmdStorage.end(), buf, readSize );
                m_currentCmdStorage.setSizeUnchecked( m_currentCmdBytesRead + readSize );

                m_currentCmdBytesRead += readSize;
                m_currentCmdTotalBytes = ( m_currentCmdBytesRead >= 4 ) ? currentCmd()->getCmdSize() : HK_INT32_MAX;

                if ( m_currentCmdBytesRead == m_currentCmdTotalBytes )
                {
                    cmd = currentCmd();
                    const hkUint8 serverType = cmd->getServerType();
                    if ( serverType == 0 )
                    {
#if 0
                        // Write our meta data
                        {
                            // Write our patched type
                            {
                                const hkUint8 type = 0;

                                m_currentCmdBytesRead += sizeof( type );
                                m_currentCmdStorage.reserve( m_currentCmdBytesRead );
                                *reinterpret_cast< hkUint8* >( m_currentCmdStorage.end() ) = 0;
                                m_currentCmdStorage.setSizeUnchecked( m_currentCmdBytesRead );
                            }

                            // Write our index in the frame, this is used for cmd order comparisons during playback
                            {
                                const hkUint32 commandIdx = hkUint32( 0 );

                                m_currentCmdBytesRead += sizeof( commandIdx );
                                m_currentCmdStorage.reserve( m_currentCmdBytesRead );
                                *reinterpret_cast< hkUint32* >( m_currentCmdStorage.end() ) = commandIdx;
                                m_currentCmdStorage.setSizeUnchecked( m_currentCmdBytesRead );
                            }

                            m_currentCmdTotalBytes = m_currentCmdBytesRead;
                        }
#endif
                        // Ack the frame
                        if ( m_writer )
                        {
                            hkVdbOStream output( m_writer );
                            output.write8u( 0 );
                        }
                    }
                }

                return readSize;
            }
            else
            {
                return NoOpReader::read( buf, nbytes );
            }
        }
        HK_INLINE hkVdbCmd* currentCmd()
        {
            return
                m_currentCmdStorage.getSize() >= (int) hkVdbCmd::getHeaderSize() ?
                    reinterpret_cast< hkVdbCmd* >( m_currentCmdStorage.begin() ) :
                    HK_NULL;
        }
        hkStreamReader* m_reader;
        hkStreamWriter* m_writer;
        int m_currentCmdBytesRead;
        int m_currentCmdTotalBytes;
        hkArray<char> m_currentCmdStorage;
    };
}

hkVdbNoOpConnection::hkVdbNoOpConnection( hkVdbConnection* connection ) :
    hkVdbConnection( &s_debugLog ),
    m_connection( connection ),
    m_state( hkVdbConnectionState::DISCONNECTED )
{
    if ( !connection ) m_reader = hkRefNew<NoOpReader>( new NoOpReader() );
    m_writer = hkRefNew<NoOpWriter>( new NoOpWriter() );
}

hkVdbConnectionState::Enum hkVdbNoOpConnection::getState() const
{
    if ( m_connection )
    {
        return m_connection->getState();
    }
    else
    {
        return m_state;
    }
}

hkResult hkVdbNoOpConnection::connect()
{
    if ( m_connection )
    {
        hkResult success = m_connection->connect();
        m_reader = hkRefNew<NoOpReader>( new NoOpAckReader( m_connection->getReader(), m_connection->getWriter() ) );
        return success;
    }
    else
    {
        m_state = hkVdbConnectionState::CONNECTED;
        return HK_SUCCESS;
    }
}

hkResult hkVdbNoOpConnection::disconnect()
{
    if ( m_connection )
    {
        m_reader = HK_NULL;
        return m_connection->disconnect();
    }
    else
    {
        m_state = hkVdbConnectionState::DISCONNECTED;
        return HK_SUCCESS;
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
