// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/hkSignalSlots.h>
#include <Common/Base/System/Stopwatch/hkStopwatch.h>

#include <VisualDebugger/VdbServices/System/Connection/hkVdbConnection.h>

class hkInetAddr;
class hkSocket;
class hkBufferedStreamReader;
class hkThread;

//////////////////////////////////////////////////////////////////////////
/// Network events enum
//////////////////////////////////////////////////////////////////////////
struct HK_EXPORT_VDB hkVdbNetworkEvent
{
    enum Enum
    {
        /// The socket has disconnected.
        DISCONNECTED = 0,

        /// The socket is connecting.
        CONNECTING,

        /// The socket has connected.
        CONNECTED,

        /// The socket has errored.
        ERRORED,

        /// The socket has data to read.
        READ_READY
    };
};

//////////////////////////////////////////////////////////////////////////
/// A connection which reads/writes cmds from/to over the network.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbNetworkConnection : public hkVdbConnection
{
public:
    HK_DECLARE_CLASS( hkVdbNetworkConnection, New, ReflectIdentity );

    /// Creates a network connection to the provided machine/port.
    /// The connection will be in the error state if it fails to connect
    /// after the timeoutMs.
    hkVdbNetworkConnection( const char* machineName, int port, hkReal timeoutMs );

    /// Creates a network connection which listens on the port for connections.
    /// New connections are established when poll() is called (as it is by hkVdbClient::poll()).
    hkVdbNetworkConnection( int listeningPort );

    // dtor
    ~hkVdbNetworkConnection();

    /// Get currently connected addresses.
    virtual hkResult getConnectedAddresses( hkArray<hkInetAddr>& addrsOut );

    //
    // hkVdbConnection interface
    //

    virtual hkVdbConnectionState::Enum getState() const HK_OVERRIDE;
    virtual hkResult connect() HK_OVERRIDE;
    virtual hkResult disconnect() HK_OVERRIDE;
    virtual hkResult poll() HK_OVERRIDE;
    virtual hkStreamReader* getReader() HK_OVERRIDE;
    virtual hkStreamWriter* getWriter() HK_OVERRIDE;

    //
    // Signals
    //

    HK_DECLARE_SIGNAL( NetworkEventReceivedSignal, hkSignal1< hkVdbNetworkEvent::Enum > );
    /// Signal fires when a network event is processed.
    /// Note: This signal is called from a background thread.
    NetworkEventReceivedSignal m_networkEventReceived;

protected:

    void updateState() const;
    hkBool32 isValidSocket( hkSocket& socket ) const;
    hkResult checkBackgroundThreadForError() const;
    hkResult signalBackgroundThreadCleanup();
    hkResult waitForBackgroundThreadCleanup();

    mutable hkUint32 m_state;
    hkThread* m_networkThread;
    void* m_networkThreadData;
    hkStringPtr m_machineName;
    int m_port;
    hkReal m_timeoutMs;
    hkStopwatch m_timeoutWatch;
    hkRefPtr<hkSocket> m_socket;
    hkRefPtr<hkBufferedStreamReader> m_socketReader;
    hkArray< hkRefPtr<hkSocket> > m_connectedSockets;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
