// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/System/Io/FileSystem/hkFileSystem.h>
#include <VisualDebugger/VdbServices/System/Connection/hkVdbConnection.h>

class hkVdbBoundlessReader;

//////////////////////////////////////////////////////////////////////////
/// A connection which reads/writes cmds from/to a file.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbFileConnection : public hkVdbConnection
{
public:
    HK_DECLARE_CLASS( hkVdbFileConnection, New, ReflectIdentity );

    /// Creates a file connection with the specified access mode.
    /// Note: the access mode will determine if the connection can read and/or write.
    hkVdbFileConnection( const char* filepath, hkFileSystem::AccessMode mode );
    ~hkVdbFileConnection();

    /// If the file system returned an hkSeekableStreamReader, it is wrapped in a
    /// hkVdbBoundlessReader so that it will not get invalidated due to a read.
    /// This class can also report when EOF is reached.
    hkVdbBoundlessReader* getBoundlessReader() { return m_boundlessReader; }

    //
    // hkVdbConnection interface
    //

    virtual hkVdbConnectionState::Enum getState() const HK_OVERRIDE;
    virtual hkResult connect() HK_OVERRIDE;
    virtual hkResult disconnect() HK_OVERRIDE;
    virtual hkStreamReader* getReader() HK_OVERRIDE;
    virtual hkStreamWriter* getWriter() HK_OVERRIDE;

protected:

    hkStringPtr m_filepath;
    const hkFileSystem::AccessMode m_mode;

    hkRefPtr<hkStreamReader> m_reader;
    hkRefPtr<hkStreamWriter> m_writer;
    hkViewPtr<hkVdbBoundlessReader> m_boundlessReader;

    hkVdbConnectionState::Enum m_state;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
