// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Connection/hkVdbFileConnection.h>

#include <Common/Base/System/Io/Reader/hkStreamReader.h>
#include <Common/Base/System/Io/Writer/hkStreamWriter.h>

#include <VisualDebugger/VdbServices/System/Utils/hkVdbBoundlessReader.h>

#define DEBUG_LOG_IDENTIFIER "vdb.Connection.File"
#include <Common/Base/System/Log/hkLog.hxx>




hkVdbFileConnection::hkVdbFileConnection(
    const char* filepath,
    hkFileSystem::AccessMode mode ) :
    hkVdbConnection( &s_debugLog ),
    m_filepath( filepath ),
    m_mode( mode )
{
    clearError();
}
hkVdbFileConnection::~hkVdbFileConnection()
{}

hkVdbConnectionState::Enum hkVdbFileConnection::getState() const
{
    if ( m_mode == hkFileSystem::ACCESS_READ )
    {
        if ( m_reader )
        {
            if ( HK_VERY_LIKELY( m_reader->isOk() ) )
            {
                return hkVdbConnectionState::CONNECTED;
            }
            else
            {
                HK_VDB_SIGNAL_ERROR_MSG(
                    0xedb00082,
                    hkVdbError::IO_ERROR,
                    "Reader for \"" << m_filepath.cString() << "\" is not valid" );

                return hkVdbConnectionState::ERRORED;
            }
        }
        else
        {
            return hkVdbConnectionState::DISCONNECTED;
        }
    }
    else
    {
        if ( m_writer )
        {
            if ( HK_VERY_LIKELY( m_writer->isOk() ) )
            {
                return hkVdbConnectionState::CONNECTED;
            }
            else
            {
                HK_VDB_SIGNAL_ERROR_MSG(
                    0xedb00081,
                    hkVdbError::IO_ERROR,
                    "Writer for \"" << m_filepath.cString() << "\" is not valid" );

                return hkVdbConnectionState::ERRORED;
            }
        }
        else
        {
            return hkVdbConnectionState::DISCONNECTED;
        }
    }
}

hkResult hkVdbFileConnection::connect()
{
    if ( m_mode == hkFileSystem::ACCESS_READ )
    {
        m_reader = hkFileSystem::getInstance().openReader( m_filepath );
        if ( m_reader )
        {
            if ( hkSeekableStreamReader* seekableReader = m_reader->isSeekTellSupported() )
            {
                m_boundlessReader = new hkVdbBoundlessReader( *seekableReader );
                m_reader = hkRefNew<hkVdbBoundlessReader>( m_boundlessReader.val() );
            }

            if ( m_reader->isOk() )
            {
                return HK_SUCCESS;
            }
        }
    }
    else
    {
        m_writer = hkFileSystem::getInstance().openWriter( m_filepath );
        if ( m_writer )
        {
            if ( m_writer->isOk() )
            {
                return HK_SUCCESS;
            }
        }
    }

    HK_VDB_SIGNAL_ERROR_MSG(
        0xedb00083,
        hkVdbError::IO_ERROR,
        "Could not open " << ( ( m_mode == hkFileSystem::ACCESS_WRITE ) ? "writer" : "reader" ) << " for \"" << m_filepath.cString() << "\"" );

    return HK_FAILURE;
}

hkResult hkVdbFileConnection::disconnect()
{
    
    
    
    m_reader = HK_NULL;
    m_writer = HK_NULL;
    m_boundlessReader = HK_NULL;
    return HK_SUCCESS;
}

hkStreamReader* hkVdbFileConnection::getReader()
{
    return m_reader;
}

hkStreamWriter* hkVdbFileConnection::getWriter()
{
    return m_writer;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
