// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <VisualDebugger/VdbServices/hkVdbServices.h>
#include <VisualDebugger/VdbServices/System/Connection/hkVdbDebugFileConnection.h>

#include <VisualDebugger/VdbServices/System/Utils/hkVdbDebugWriter.h>

hkVdbDebugFileConnection::hkVdbDebugFileConnection(
    hkVdbCmdInput& input,
    const char* filepath ) :
    hkVdbFileConnection( filepath, hkFileSystem::ACCESS_WRITE )
{
    m_writer = hkRefNew<hkVdbDebugWriter>( new hkVdbDebugWriter( input, filepath ) );
    clearError();
}

hkResult hkVdbDebugFileConnection::connect()
{
    if ( m_writer && m_writer->isOk() )
    {
        return HK_SUCCESS;
    }

    HK_VDB_SIGNAL_ERROR_MSG(
        0xedb00085,
        hkVdbError::IO_ERROR,
        "Could not open " << ( ( m_mode == hkFileSystem::ACCESS_WRITE ) ? "writer" : "reader" ) << " for \"" << m_filepath.cString() << "\"" );

    return HK_FAILURE;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
