// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class hkStreamReader;
class hkStreamWriter;

//////////////////////////////////////////////////////////////////////////
/// Enum of different states a connection can be in.
//////////////////////////////////////////////////////////////////////////
namespace hkVdbConnectionState
{
    enum Enum
    {
        /// We not yet started connecting.
        DISCONNECTED = 0,

        /// We have started connecting but have not yet established our connection.
        CONNECTING,

        /// Our connection has been established.
        CONNECTED,

        /// There was an error which disrupted one or more connections
        ERRORED,
    };
}

//////////////////////////////////////////////////////////////////////////
/// Enum of different uses a connection can have.
//////////////////////////////////////////////////////////////////////////
namespace hkVdbConnectionUse
{
    enum Enum
    {
        
        /// If there's a valid application connection, it will be read from during process calls
        /// and written to when flushing the cmd output.
        APPLICATION,

        /// If there's a valid server discovery connection, it will build information about
        /// discovered servers during poll() operations.
        APPLICATION_SERVER_DISCOVERY,

        /// If there's a valid sink connection, it will be written to when a command
        /// is completed during process calls. The hkVdbClient will delay connection of SINKs
        /// until the current step is completed but *will not* wait when asked to disconnect.
        /// This is because starting to write mid-step will produce a corrupt stream, but
        /// a stream that ends mid-step will not be corrupt.
        SINK,
        

        /// Number of uses
        NUM_USES
    };
}

//////////////////////////////////////////////////////////////////////////
/// Instances of this class define a one or two-way connection.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbConnection : public hkVdbDefaultErrorReporter
{
public:
    HK_DECLARE_CLASS( hkVdbConnection, New, Reflect, ReflectDetails( parents = false, specials = false, fields = false ) );

    /// Creates a new connection which reports errors from the provided log origin.
    hkVdbConnection( hkLog::Origin* log ) : hkVdbDefaultErrorReporter( log ) {}

    /// Get's the current connection state.
    virtual hkVdbConnectionState::Enum getState() const = 0;
    

    /// Start connecting.
    virtual hkResult connect() = 0;

    /// Start disconnecting.
    virtual hkResult disconnect() = 0;

    /// Called when hkVdbClient::poll() is called.
    
    
    
    virtual hkResult poll() { return HK_SUCCESS; };

    /// Get a reader for the connection.
    /// Not all connection uses require a reader.
    /// Note: read failures will result in the connection being queried for errors.
    virtual hkStreamReader* getReader() = 0;

    /// Get a writer for the connection.
    /// Not all connection uses require a writer.
    /// Note: write failures will result in the connection being queried for errors.
    virtual hkStreamWriter* getWriter() = 0;
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
