// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

//////////////////////////////////////////////////////////////////////////
// hkVdbPartialCmd
//////////////////////////////////////////////////////////////////////////

HK_INLINE const hkVdbCmd* hkVdbFrame::hkVdbPartialCmd::peek() const
{
    const hkVdbCmd* cmd = reinterpret_cast< hkVdbCmd* >( currentStorage()->m_storage.begin() + m_partialCmdStartIndex );
    return cmd;
}

HK_INLINE const hkVdbCmd* hkVdbFrame::hkVdbPartialCmd::advance()
{
    const hkVdbCmd* command = peek();
    CommandStorageBlock* storageBlock = currentStorage();
    m_partialCmdStartIndex = storageBlock->m_storage.getSize();
    storageBlock->m_cmdOffsets.pushBack( m_partialCmdStartIndex );
    return command;
}

HK_INLINE hkUint32 hkVdbFrame::hkVdbPartialCmd::getHeaderSize() const
{
    const hkUint32 headerSize = peek()->getHeaderSize();
    return headerSize;
}

HK_INLINE hkUint32 hkVdbFrame::hkVdbPartialCmd::getBodySize() const
{
    HK_ASSERT( 0x22440805, getNumCompleted() >= peek()->getHeaderSize(), "The header has not yet been read" );
    const hkUint32 bodySize = peek()->getBodySize();
    return bodySize;
}

HK_INLINE hkInt8* hkVdbFrame::hkVdbPartialCmd::getWriteLoc()
{
    return currentStorage()->m_storage.end();
}

HK_INLINE void hkVdbFrame::hkVdbPartialCmd::setCompleted( int numBytes )
{
    currentStorage()->m_storage.setSizeUnchecked( m_partialCmdStartIndex + numBytes );
}

HK_INLINE hkUint32 hkVdbFrame::hkVdbPartialCmd::getNumCompleted() const
{
    HK_ASSERT_NO_MSG( 0x22441127, currentStorage()->m_storage.getSize() >= m_partialCmdStartIndex );
    const hkUint32 numCompleted = ( currentStorage()->m_storage.getSize() - m_partialCmdStartIndex );
    return numCompleted;
}

HK_INLINE void hkVdbFrame::hkVdbPartialCmd::clear()
{
    setCompleted( 0 );
}

//////////////////////////////////////////////////////////////////////////
// hkVdbFrame
//////////////////////////////////////////////////////////////////////////

HK_INLINE hkVdbFrame::Iterator hkVdbFrame::getIterator( hkInt64 cmdIndex ) const
{
    const hkVdbFrame::Iterator iter = ( cmdIndex < 0 ) ? 0 : hkVdbFrame::Iterator( cmdIndex );
    return iter;
}

HK_INLINE hkVdbFrame::Iterator hkVdbFrame::getNext( Iterator i ) const
{
    HK_ASSERT( 0x22440806, isValid( i ), "Iterator is no longer valid" );
    i++;
    const CommandStorageBlock* storage = getStorageFor( i );
    const hkVdbFrame::Iterator iter = ( storage ) ? i : hkVdbFrame::InvalidIterator;
    return iter;
}

HK_INLINE const hkVdbCmd* hkVdbFrame::getValue( Iterator i ) const
{
    HK_ASSERT( 0x22440808, isValid( i ), "Iterator is no longer valid" );
    const CommandStorageBlock* storage = getStorageFor( i );
    const hkInt32 cmdOffsetIndex = ( i - storage->m_startingCmdIndex - 1 );
    const hkVdbCmd* cmd =
        reinterpret_cast< const hkVdbCmd* >(
            // Start of storage
            storage->m_storage.begin() +
            // Plus offset
            ( ( cmdOffsetIndex < 0 ) ? 0 : storage->m_cmdOffsets[cmdOffsetIndex] ) );
    return cmd;
}

HK_INLINE hkBool32 hkVdbFrame::isValid( Iterator i ) const
{
    const hkBool32 isValid = ( i != hkVdbFrame::InvalidIterator ) && ( getStorageFor( i ) );
    return isValid;
}

//////////////////////////////////////////////////////////////////////////
// hkVdbCmdInput
//////////////////////////////////////////////////////////////////////////

HK_INLINE hkVdbCmdInput::Iterator hkVdbCmdInput::getIterator( hkInt64 frameIn ) const
{
    const hkUint32 frame = ( frameIn < 0 ) ? m_startingFrameNumber : hkUint32( frameIn );
    const hkUint32 relativeFrameIdx = ( frame - m_startingFrameNumber );
    if ( ( frame < m_startingFrameNumber ) || ( relativeFrameIdx > getNumFrames() ) )
    {
        return hkVdbCmdInput::InvalidIterator;
    }
    const hkVdbCmdInput::Iterator iter = ( ( m_startingFrameIdx + relativeFrameIdx ) % m_frameStorage.getSize() );
    return iter;
}

HK_INLINE hkVdbCmdInput::Iterator hkVdbCmdInput::getNext( Iterator i ) const
{
    HK_ASSERT( 0x22440810, isValid( i, true ), "Iterator is no longer valid." );
    if ( i == m_currentFrameIdx ) return hkVdbCmdInput::InvalidIterator;
    const hkVdbCmdInput::Iterator iter = ( ( i + 1 ) % m_frameStorage.getSize() );
    return iter;
}

HK_INLINE hkVdbCmdInput::Iterator hkVdbCmdInput::getPrevious( Iterator i ) const
{
    HK_ASSERT( 0x22440811, isValid( i, true ), "Iterator is no longer valid." );
    if ( i == m_startingFrameIdx ) return hkVdbCmdInput::InvalidIterator;
    i--;
    const hkVdbCmdInput::Iterator iter = ( m_frameStorage.getSize() * ( i < 0 ) + i );
    return iter;
}

HK_INLINE const hkVdbFrame* hkVdbCmdInput::getValue( Iterator i ) const
{
    HK_ASSERT( 0x22440812, isValid( i, true ), "Iterator is no longer valid." );
    const hkVdbFrame* frame = &m_frameStorage[i];
    return frame;
}

HK_INLINE hkBool32 hkVdbCmdInput::isValid( Iterator i, bool includeCurrentFrame ) const
{
    HK_ASSERT( 0x22440843, ( m_startingFrameIdx != m_currentFrameIdx ) || ( m_frameStorage.getSize() == 1 ), "Degenerate buffer, no current frame" );

    const hkBool32 wrapped = ( m_startingFrameIdx > m_currentFrameIdx );
    const hkBool32 insideCurrentFrameBounds = ( ( i - includeCurrentFrame ) < m_currentFrameIdx );

    const hkBool32 isValid =
        // If we're currently wrapped around the end, then if we are greater or equal to start
        // OR less than current, we are in a valid interval.
        // (O = Valid data, C = current frame index data, X = Invalid data, S = starting frame index data)
        // [OOOOOOOOOOO_C_XXXX_S_OOOOOOOOOOOO]
        ( wrapped && ( i >= 0 ) && ( ( i >= m_startingFrameIdx ) || insideCurrentFrameBounds ) && ( i < m_frameStorage.getSize() ) ) ||
        // If we're not wrapped, then we must be both above starting frame index and below current frame index
        // [XXXXXXXXXXX_S_OOOO_C_XXXXXXXXXXXX]
        ( !wrapped && ( ( i >= m_startingFrameIdx ) && insideCurrentFrameBounds ) );

    return isValid;
}

HK_INLINE hkUint32 hkVdbCmdInput::getNumFrames() const
{
    HK_ASSERT( 0x22440813, ( m_startingFrameIdx != m_currentFrameIdx ) || ( m_frameStorage.getSize() == 1 ), "Degenerate buffer, no current frame" );

    const bool wrapped = ( m_startingFrameIdx > m_currentFrameIdx );

    const hkUint32 numFrames =
        hkUint32(
            // Start with all the storage we've allocated.
            m_frameStorage.getSize()
            // If we're currently wrapped around the end, then we need to subtract the gap between current frame index and starting frame index
            // (O = Valid data, C = current frame index data, X = Invalid data, S = starting frame index data)
            // [OOOOOOOOOOO_C_XXXX_S_OOOOOOOOOOOO]
            -( wrapped * ( m_startingFrameIdx - m_currentFrameIdx ) )
            // If we're not wrapped, then we need to subtract the leading and trailing invalid data
            // [XXXXXXXXXXX_S_OOOO_C_XXXXXXXXXXXX]
            - ( !wrapped * ( m_startingFrameIdx + m_frameStorage.getSize() - m_currentFrameIdx ) ) );

    return numFrames;
}

HK_INLINE hkResult hkVdbCmdInput::getFrameRange( hkUint32& minFrameOut, hkUint32& maxFrameOut ) const
{
    minFrameOut = getStartingFrameNumber();
    maxFrameOut = getCurrentFrameNumber();
    return HK_SUCCESS;
}

HK_INLINE hkBool32 hkVdbCmdInput::isFull() const
{
    const hkVdbFrame* oldestFrame = begin();
    const hkVdbFrame* currentFrame = peek();
    // Note: m_duration == 0 indicates an ever-growing cache (never gets full)
    return ( ( m_duration > 0 ) && ( ( currentFrame->m_startTime - oldestFrame->m_startTime ) > m_duration ) );
}

HK_INLINE const hkVdbFrame* hkVdbCmdInput::peek() const
{
    const hkVdbFrame* frame = const_cast< hkVdbCmdInput* >( this )->current();
    return frame;
}

HK_INLINE const hkVdbFrame* hkVdbCmdInput::begin() const
{
    const hkVdbFrame* frame = &m_frameStorage[m_startingFrameIdx];
    return frame;
}

HK_INLINE const hkVdbFrame* hkVdbCmdInput::back() const
{
    const int prevIndex = ( m_currentFrameIdx - 1 );
    const hkVdbFrame* frame = &m_frameStorage[m_frameStorage.getSize() * ( prevIndex < 0 ) + prevIndex];
    return frame;
}

HK_INLINE const hkVdbFrame* hkVdbCmdInput::getFrame( int frameNum ) const
{
    Iterator iter = getIterator( frameNum );
    if ( iter == m_currentFrameIdx )
    {
        const hkVdbFrame* frame = peek();
        return frame;
    }
    else if ( isValid( iter ) )
    {
        const hkVdbFrame* frame = getValue( iter );
        return frame;
    }
    return HK_NULL;
}

HK_INLINE void hkVdbCmdInput::unreserveCustomStorage( hkUint32 id )
{
    setCustomFrameReserveBytes( id, 0, ZERO );
}

HK_INLINE hkVdbFrame* hkVdbCmdInput::current()
{
    hkVdbFrame* frame = &m_frameStorage[m_currentFrameIdx];
    return frame;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
