// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Types/hkSignalSlots.h>

#include <VisualDebugger/VdbServices/System/Command/hkVdbCmd.h>

struct hkVdbFrame;

//////////////////////////////////////////////////////////////////////////
/// A func which can handle processing of a vdb cmd.
//////////////////////////////////////////////////////////////////////////
typedef hkResult( HK_CALL *hkVdbCmdHandlerFunc )(
    const hkVdbFrame& frame,
    const hkVdbCmd& cmd,
    int protocol,
    struct hkVdbLocalIStream& dataReader,
    hkVdbProcessInfo* processInfo,
    void* userHandle );

//////////////////////////////////////////////////////////////////////////
/// A dispatcher of vdb cmds to registered handlers.
//////////////////////////////////////////////////////////////////////////
class HK_EXPORT_VDB hkVdbCmdDispatcher : public hkVdbDefaultErrorReporter
{
public:
    HK_DECLARE_CLASS( hkVdbCmdDispatcher, New );
    hkVdbCmdDispatcher();

    /// Dispatch a cmd to the registered handler (if any).
    hkResult dispatch( const hkVdbFrame& frame, const hkVdbCmd& cmd, int protocol, hkVdbProcessInfo* processInfo = HK_NULL );

    /// Register a handler for a particular cmd type.
    hkResult registerHandler( hkVdbCmdType::Enum cmdType, hkVdbCmdHandlerFunc func, hkVdbErrorReporter* errorReporter = HK_NULL, void* userHandle = HK_NULL );

    /// Unregister a handler for a particular cmd type.
    hkResult unregisterHandler( hkVdbCmdType::Enum cmdType );

    HK_DECLARE_SIGNAL( CmdDispatchingSignal, hkSignal4< const hkVdbFrame&, const hkVdbCmd&, int /*protocol*/, hkVdbSignalResult& > );
    /// Fires just before a cmd is about to be dispatched.
    CmdDispatchingSignal m_cmdDispatching;

    HK_DECLARE_SIGNAL( CmdDispatchedSignal, hkSignal4< const hkVdbFrame&, const hkVdbCmd&, int /*protocol*/, hkVdbSignalResult& > );
    /// Fires just after a cmd has been dispatched.
    CmdDispatchedSignal m_cmdDispatched;

protected:

    struct DispatchEntry
    {
        HK_DECLARE_CLASS( DispatchEntry, New );
        DispatchEntry() : m_func(HK_NULL), m_handle(HK_NULL) {}
        hkVdbCmdHandlerFunc m_func;
        hkRefPtr<hkVdbErrorReporter> m_errorReporter;
        void* m_handle;
    };

    hkArray<DispatchEntry> m_dispatchTable;
    HK_DEBUG_ONLY_MEMBER( const hkVdbCmd*, m_lastDispatchedCmd );
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
