// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM     : WIN32 X64 UWP
// PRODUCT      : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Visualize/hkVisualDebuggerCmd.h>

//////////////////////////////////////////////////////////////////////////
/// Enum values for internal cmds types.
//////////////////////////////////////////////////////////////////////////
namespace hkVdbInternalCmdType
{
    enum Enum
    {
        //////////////////////////////////////////////////////////////////////////
        // hkVdbServices internal cmds
        // Note: Don't change order for back-ward compatibility
        //////////////////////////////////////////////////////////////////////////

        /// Marker for invalid cmds if we need to stop supporting something.
        INVALID = hkUint8( -1 ),

        /// A cmd which contains stat maps for use with stats handling.
        LOAD_VERSIONED_STAT_MAPS = 0, // Deprecated

        /// A cmd containing a debug tag/string.
        DEBUG_TAG,

        /// A cmd to dispatch another cmd.
        DISPATCH_CMD,

        /// A cmd which contains data for an hkPersistableReadFormat.
        UNPERSIST_READ_FORMAT,

        //////////////////////////////////////////////////////////////////////////
        // Custom at the end
        //////////////////////////////////////////////////////////////////////////

        /// Custom internal cmds for use by clients and others.
        /// Similar in behavior to CUSTOM cmd. First 16-bit value
        /// is expected to be a sub-type id as determined by
        /// hkVdbCustomCmdType.
        CUSTOM = 253,
    };
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
